package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.auc.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 开放平台用户信息查询服务
 */
@Service("eleme.auc")
public class AucService extends BaseNopService {
    public AucService(Config config,Token token) {
        super(config, token, AucService.class);
    }

    /**
     * 获取预授权令牌
     *
     * @param request 查询条件
     * @return 预授权模型
     * @throws ServiceException 服务异常
     */
    public AlscPreAuthOpenResult getUserPreAuthToken(AlscPreAuthOpenRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.auc.getUserPreAuthToken", params);
    }

    /**
     * 根据令牌查询用户信息
     *
     * @param request 查询条件
     * @return 用户信息
     * @throws ServiceException 服务异常
     */
    public AlscUserEncryptedInfo queryUserInfoByToken(AlscUserQueryOpenRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.auc.queryUserInfoByToken", params);
    }
}
