package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.canmou.*;
import eleme.openapi.sdk.api.enumeration.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 生意参谋服务
 */
@Service("eleme.canmou")
public class CanmouService extends BaseNopService {
    public CanmouService(Config config,Token token) {
        super(config, token, CanmouService.class);
    }

    /**
     * 查询实时店铺总览数据
     *
     * @param request 查询条件
     * @return 实时店铺总览数据
     * @throws ServiceException 服务异常
     */
    public List<IndicatorDetail> queryShopRealtimeOverview(NaposBaseRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.canmou.queryShopRealtimeOverview", params);
    }

    /**
     * 查询实时店铺流量数据
     *
     * @param request 查询条件
     * @return 实时店铺流量数据
     * @throws ServiceException 服务异常
     */
    public List<IndicatorDetail> queryShopRealtimeFlow(NaposBaseRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.canmou.queryShopRealtimeFlow", params);
    }

    /**
     * 分页查询实时店铺商品数据
     *
     * @param request 查询条件
     * @return 实时店铺商品数据
     * @throws ServiceException 服务异常
     */
    public NaposRealTimeShopItemPageResponse queryShopRealtimeItem(NaposPageRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.canmou.queryShopRealtimeItem", params);
    }

    /**
     * 分页查询近30天店铺商品数据
     *
     * @param request 查询条件
     * @return 近30天店铺商品数据
     * @throws ServiceException 服务异常
     */
    public NaposShopItemPageResponse queryShopHistoryItem(NaposPageRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.canmou.queryShopHistoryItem", params);
    }

    /**
     * 查询近30天店铺热销商品排行
     *
     * @param request 查询条件
     * @return top5热销商品
     * @throws ServiceException 服务异常
     */
    public List<NaposShopHotItemResponse> queryShopItemRank(NaposBaseRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.canmou.queryShopItemRank", params);
    }

    /**
     * 查询实时商圈流量数据
     *
     * @param request 查询条件
     * @return 实时商圈流量数据
     * @throws ServiceException 服务异常
     */
    public List<IndicatorDetail> queryMarketRealtimeFlow(NaposBaseRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.canmou.queryMarketRealtimeFlow", params);
    }

    /**
     * 查询近30天商圈热销商品排行
     *
     * @param request 查询条件
     * @return 近30天商圈top5商品排行数据
     * @throws ServiceException 服务异常
     */
    public List<MarketHotItemResponse> queryMarketItem(NaposBaseRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.canmou.queryMarketItem", params);
    }

    /**
     * 查询近30天商圈同品类门店月售
     *
     * @param request 查询条件
     * @return 近30天商圈门店月售数据
     * @throws ServiceException 服务异常
     */
    public MarketShopSalePageResponse queryMarketShopSale(NaposPageRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.canmou.queryMarketShopSale", params);
    }
}
