package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.coupon.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 卡券订单服务（对外提供）
 */
@Service("eleme.coupon")
public class CouponService extends BaseNopService {
    public CouponService(Config config,Token token) {
        super(config, token, CouponService.class);
    }

    /**
     * 查询卡券订单信息
     *
     * @param request 查询条件
     * @return 余额流水
     * @throws ServiceException 服务异常
     */
    public OutCouponOrderResponse queryCouponOrder(OutQueryCouponOrderRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.coupon.queryCouponOrder", params);
    }
}
