package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.crm.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * CRM会员开放平台-权益服务
 */
@Service("eleme.crm")
public class CrmService extends BaseNopService {
    public CrmService(Config config,Token token) {
        super(config, token, CrmService.class);
    }

    /**
     * 根据经纬度查询范围内的会员权益
     *
     * @param request 请求入参
     * @return 会员权益列表
     * @throws ServiceException 服务异常
     */
    public List<ElemeBenefitDTO> queryMemberBenefitByPoi(QueryMemberBenefitByPoiRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.crm.queryMemberBenefitByPoi", params);
    }

    /**
     * 会员退会
     *
     * @param request 请求参数
     * @return 
     * @throws ServiceException 服务异常
     */
    public IsvExitMembershipResponse exitMembership(IsvExitMembershipRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.crm.exitMembership", params);
    }
}
