package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.customerOrder.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 订单服务
 */
@Service("eleme.customerOrder")
public class CustomerOrderService extends BaseNopService {
    public CustomerOrderService(Config config,Token token) {
        super(config, token, CustomerOrderService.class);
    }

    /**
     * 查询用户当前月订单信息
     *
     * @param request 手机号信息
     * @return 当月订单信息
     * @throws ServiceException 服务异常
     */
    public QueryTradeInfoResponse queryCurrMonTradeInfo(QueryTradeInfoRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.customerOrder.queryCurrMonTradeInfo", params);
    }
}
