package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.dingding.*;
import eleme.openapi.sdk.api.enumeration.dingding.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 生活钉接口
 */
@Service("eleme.dingding")
public class DingdingService extends BaseNopService {
    public DingdingService(Config config,Token token) {
        super(config, token, DingdingService.class);
    }

    /**
     * 生活钉首页接口
     *
     * @param request 钉钉入参
     * @return 首页
     * @throws ServiceException 服务异常
     */
    public LifeDingResponse queryTransformerV1LifeDing(LifeDingRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.dingding.queryTransformerV1LifeDing", params);
    }

    /**
     * 生活钉回收接口for推荐列表
     *
     * @param request 钉钉入参
     * @return 推荐列表
     * @throws ServiceException 服务异常
     */
    public LifeDingResponse collectTransformerV1LifeDing(LifeDingRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.dingding.collectTransformerV1LifeDing", params);
    }
}
