package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.market.*;
import eleme.openapi.sdk.api.enumeration.market.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 服务市场服务
 */
@Service("eleme.market")
public class MarketService extends BaseNopService {
    public MarketService(Config config,Token token) {
        super(config, token, MarketService.class);
    }

    /**
     * 同步某一段时间内的服务市场消息
     *
     * @param start 开始时间
     * @param end 结束时间
     * @param offset 消息偏移量
     * @param limit 查询消息数
     * @return 服务市场订单
     * @throws ServiceException 服务异常
     */
    public MarketMessages syncMarketMessages(Date start, Date end, int offset, int limit) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("start", start);
        params.put("end", end);
        params.put("offset", offset);
        params.put("limit", limit);
        return call("eleme.market.syncMarketMessages", params);
    }

    /**
     * 创建内购项目订单
     *
     * @param request 创建订单请求信息
     * @return 订单编号
     * @throws ServiceException 服务异常
     */
    public String createOrder(OrderRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.market.createOrder", params);
    }

    /**
     * 查询服务市场订单
     *
     * @param orderNo 服务市场订单编号
     * @return 订单详情
     * @throws ServiceException 服务异常
     */
    public OrderQueryResponse queryOrder(String orderNo) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orderNo", orderNo);
        return call("eleme.market.queryOrder", params);
    }

    /**
     * 服务市场确认订单
     *
     * @param orderNo 服务市场订单编号
     * @throws ServiceException 服务异常
     */
    public void confirmOrder(String orderNo) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orderNo", orderNo);
        call("eleme.market.confirmOrder", params);
    }

    /**
     * 物联网设备确认出餐
     *
     * @param deviceInfo 设备信息
     * @param orderId 订单id
     * @throws ServiceException 服务异常
     */
    public void markFinishCookingTime(ODeviceInfo deviceInfo, String orderId) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("deviceInfo", deviceInfo);
        params.put("orderId", orderId);
        call("eleme.market.markFinishCookingTime", params);
    }

    /**
     * 线下服务上传订单物流单号
     *
     * @param logisticInfos 订单物流信息(最多100条)
     * @throws ServiceException 服务异常
     */
    public void uploadLogisticInfo(List<LogisticInfo> logisticInfos) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("logisticInfos", logisticInfos);
        call("eleme.market.uploadLogisticInfo", params);
    }

    /**
     * 获取文件上传秘钥信息
     *
     * @return 文件上传秘钥信息
     * @throws ServiceException 服务异常
     */
    public FileUploadSignatureInfo getUploadFileSignatureInfo() throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        return call("eleme.market.getUploadFileSignatureInfo", params);
    }

    /**
     * 上传图片信息
     *
     * @param imageInfos 图片信息(最多100条)
     * @throws ServiceException 服务异常
     */
    public void uploadImageInfo(List<ImageInfo> imageInfos) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("imageInfos", imageInfos);
        call("eleme.market.uploadImageInfo", params);
    }

    /**
     * 查询服务市场线下服务订单
     *
     * @param orderNo 服务市场订单编号
     * @return 订单详情
     * @throws ServiceException 服务异常
     */
    public OfflineOrderQueryResponse queryOfflineOrder(String orderNo) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orderNo", orderNo);
        return call("eleme.market.queryOfflineOrder", params);
    }
}
