package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.msgNew.*;
import java.util.HashMap;
import java.util.Map;

/**
 * 新消息服务
 */
@Service("eleme.msgNew")
public class MsgNewService extends BaseNopService {
    public MsgNewService(Config config,Token token) {
        super(config, token, MsgNewService.class);
    }

    /**
     * 获取推送失败的消息列表
     *
     * @param msgQueryRequest 查询条件
     * @return 
     * @throws ServiceException 服务异常
     */
    public MsgQueryResult getPushFailMsg(MsgQueryRequest msgQueryRequest) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("msgQueryRequest", msgQueryRequest);
        return call("eleme.msgNew.getPushFailMsg", params);
    }

    /**
     * 向平台确认已成功拉取推送失败的消息
     *
     * @param msgConfirmRequest 查询条件
     * @return 
     * @throws ServiceException 服务异常
     */
    public MsgConfirmResult confirmPullMsg(MsgConfirmRequest msgConfirmRequest) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("msgConfirmRequest", msgConfirmRequest);
        return call("eleme.msgNew.confirmPullMsg", params);
    }
}
