package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.msorder.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 商家服务中台服务
 */
@Service("eleme.msorder")
public class MsorderService extends BaseNopService {
    public MsorderService(Config config,Token token) {
        super(config, token, MsorderService.class);
    }

    /**
     * 服务单-列表查询
     *
     * @param queryListRequest 服务单列表查询入参
     * @return 服务单列表数据
     * @throws ServiceException 服务异常
     */
    public OMSOrderList queryList(QueryListRequest queryListRequest) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("queryListRequest", queryListRequest);
        return call("eleme.msorder.queryList", params);
    }

    /**
     * 投诉单-明细查询
     *
     * @param queryComplaintDetailRequest 投诉单详情入参
     * @return 投诉单明细数据
     * @throws ServiceException 服务异常
     */
    public OComplaintOrder queryComplaintDetail(QueryComplaintDetailRequest queryComplaintDetailRequest) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("queryComplaintDetailRequest", queryComplaintDetailRequest);
        return call("eleme.msorder.queryComplaintDetail", params);
    }

    /**
     * 投诉单-协商同意
     *
     * @param complaintAgreeRequest 商户同意投诉入参
     * @throws ServiceException 服务异常
     */
    public void complaintAgree(ComplaintAgreeRequest complaintAgreeRequest) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("complaintAgreeRequest", complaintAgreeRequest);
        call("eleme.msorder.complaintAgree", params);
    }

    /**
     * 投诉单-申请平台介入
     *
     * @param complaintApplyPlatformRequest 商家申请平台介入入参
     * @throws ServiceException 服务异常
     */
    public void complaintApplyPlatform(ComplaintApplyPlatformRequest complaintApplyPlatformRequest) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("complaintApplyPlatformRequest", complaintApplyPlatformRequest);
        call("eleme.msorder.complaintApplyPlatform", params);
    }

    /**
     * 投诉单-发券
     *
     * @param complaintSendVoucherRequest 商家发券入参
     * @return 权益库发放权益结果
     * @throws ServiceException 服务异常
     */
    public OEquityPoolSendRet complaintSendVoucher(ComplaintSendVoucherRequest complaintSendVoucherRequest) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("complaintSendVoucherRequest", complaintSendVoucherRequest);
        return call("eleme.msorder.complaintSendVoucher", params);
    }
}
