package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.pintuan.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 拼团服务
 */
@Service("eleme.pintuan")
public class PintuanService extends BaseNopService {
    public PintuanService(Config config,Token token) {
        super(config, token, PintuanService.class);
    }

    /**
     * 查询单个拼团商品
     *
     * @param shopId 店铺ID
     * @param extCode 商品extCode
     * @return 拼团商品
     * @throws ServiceException 服务异常
     */
    public PinItem queryPinItemByExtCode(Long shopId, String extCode) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("extCode", extCode);
        return call("eleme.pintuan.queryPinItemByExtCode", params);
    }

    /**
     * 批量查询店铺拼团商品
     *
     * @param shopId 店铺ID
     * @return 拼团商品
     * @throws ServiceException 服务异常
     */
    public List<PinItem> getAllPinItems(Long shopId) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        return call("eleme.pintuan.getAllPinItems", params);
    }

    /**
     * 操作拼团商品上下架
     *
     * @param shopId 店铺ID
     * @param extCode 商品extCode
     * @param onShelf 上下架-1上架,0下架
     * @return 操作结果
     * @throws ServiceException 服务异常
     */
    public PinItemOperationResult updateOnShelfByExtCode(Long shopId, String extCode, Integer onShelf) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("extCode", extCode);
        params.put("onShelf", onShelf);
        return call("eleme.pintuan.updateOnShelfByExtCode", params);
    }

    /**
     * 修改拼团商品库存
     *
     * @param shopId 店铺ID
     * @param request 库存信息
     * @return 操作结果
     * @throws ServiceException 服务异常
     */
    public PinItemOperationResult updatePinTuanStock(Long shopId, UpdatePinTuanStockRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("request", request);
        return call("eleme.pintuan.updatePinTuanStock", params);
    }

    /**
     * 创建拼团商品映射，更新商品ext_code字段
     *
     * @param request 拼团商品映射信息
     * @return 操作结果
     * @throws ServiceException 服务异常
     */
    public PinItemOperationResult updatePinItemMapping(UpdatePinItemMappingRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.pintuan.updatePinItemMapping", params);
    }
}
