package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.recruitment.*;
import eleme.openapi.sdk.api.enumeration.recruitment.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 招聘市场服务
 */
@Service("eleme.recruitment")
public class RecruitmentService extends BaseNopService {
    public RecruitmentService(Config config,Token token) {
        super(config, token, RecruitmentService.class);
    }

    /**
     * 简历回传
     *
     * @param resume 简历信息
     * @return 开放平台收到简历产生的唯一标识
     * @throws ServiceException 服务异常
     */
    public String uploadResume(ResumeBody resume) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("resume", resume);
        return call("eleme.recruitment.uploadResume", params);
    }

    /**
     * 职位状态变更
     *
     * @param positionId 职位id
     * @param status 变更状态
     * @throws ServiceException 服务异常
     */
    public void updateJobPositionStatus(String positionId, PositionStatusEnum status) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("positionId", positionId);
        params.put("status", status);
        call("eleme.recruitment.updateJobPositionStatus", params);
    }

    /**
     * 简历状态变更
     *
     * @param resumeId 简历id
     * @param status 变更状态
     * @throws ServiceException 服务异常
     */
    public void updateResumeStatus(String resumeId, ResumeStatusEnum status) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("resumeId", resumeId);
        params.put("status", status);
        call("eleme.recruitment.updateResumeStatus", params);
    }

    /**
     * 回传职位曝光数据
     *
     * @param positionId 职位id
     * @param exposeCount 曝光数量
     * @param visitCount 访问数量
     * @param dataDate 数据日期
     * @throws ServiceException 服务异常
     */
    public void updatePositionExposeData(String positionId, Integer exposeCount, Integer visitCount, String dataDate) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("positionId", positionId);
        params.put("exposeCount", exposeCount);
        params.put("visitCount", visitCount);
        params.put("dataDate", dataDate);
        call("eleme.recruitment.updatePositionExposeData", params);
    }

    /**
     * 获取商户目前在架以及审核中岗位
     *
     * @return 岗位列表
     * @throws ServiceException 服务异常
     */
    public List<String> getShopJobInfos() throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        return call("eleme.recruitment.getShopJobInfos", params);
    }
}
