package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.sms.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 短信服务
 */
@Service("eleme.sms")
public class SmsService extends BaseNopService {
    public SmsService(Config config,Token token) {
        super(config, token, SmsService.class);
    }

    /**
     * 发送短信
     *
     * @param request 短信发送请求
     * @return 短信发送结果
     * @throws ServiceException 服务异常
     */
    public SmsResponse sendMessage(SmsRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.sms.sendMessage", params);
    }
}
