package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.storeScore.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 店铺分服务
 */
@Service("eleme.storeScore")
public class StoreScoreService extends BaseNopService {
    public StoreScoreService(Config config,Token token) {
        super(config, token, StoreScoreService.class);
    }

    /**
     * 查询店铺店铺分及待提升项
     *
     * @param request 查询条件
     * @return 店铺分及待提升项数据
     * @throws ServiceException 服务异常
     */
    public QueryOperationShopGrowthResponse queryOperationShopGrowth(QueryOperationShopGrowthRequest request) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("request", request);
        return call("eleme.storeScore.queryOperationShopGrowth", params);
    }
}
