package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.api.entity.user.*;
import eleme.openapi.sdk.api.enumeration.user.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

/**
 * 商户服务
 */
@Service("eleme.user")
public class UserService extends BaseNopService {
    public UserService(Config config,Token token) {
        super(config, token, UserService.class);
    }

    /**
     * 获取商户账号信息
     *
     * @return 商户账号
     * @throws ServiceException 服务异常
     */
    public OUser getUser() throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        return call("eleme.user.getUser", params);
    }

    /**
     * 获取当前授权账号的手机号,特权接口仅部分帐号可以调用
     *
     * @return 手机号
     * @throws ServiceException 服务异常
     */
    public String getPhoneNumber() throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        return call("eleme.user.getPhoneNumber", params);
    }

    /**
     * 获取授权token状态
     *
     * @param token 授权token
     * @return token信息
     * @throws ServiceException 服务异常
     */
    public TokenInfo getTokenStatus(String token) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("token", token);
        return call("eleme.user.getTokenStatus", params);
    }

    /**
     * 批量解除令牌授权
     *
     * @param authOperateReq 查询条件
     * @return 操作结果
     * @throws ServiceException 服务异常
     */
    public List<AuthOperateRes> authDelOperate(AuthOperateReq authOperateReq) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("authOperateReq", authOperateReq);
        return call("eleme.user.authDelOperate", params);
    }

    /**
     * 批量恢复令牌授权
     *
     * @param authOperateReq 查询条件
     * @return 操作结果
     * @throws ServiceException 服务异常
     */
    public List<AuthOperateRes> authRecoverOperate(AuthOperateReq authOperateReq) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("authOperateReq", authOperateReq);
        return call("eleme.user.authRecoverOperate", params);
    }

    /**
     * 获取新用户ID(openUserId)
     *
     * @param userId userId或者userIdStr均可
     * @return 加密后的用户ID
     * @throws ServiceException 服务异常
     */
    public String getOpenUserIdByUserId(String userId) throws ServiceException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        return call("eleme.user.getOpenUserIdByUserId", params);
    }
}
