package eleme.openapi.sdk.config;

import eleme.openapi.sdk.utils.StringUtils;

public class Config {

    private String app_key;
    private String app_secret;
    private String oauthCodeUrl;
    private String serverUrl;
    private String apiUrl;
    private ElemeSdkLogger elemeSdkLogger;
    //使用http连接池请求
    private boolean httpPoolRequest = false;

    public Config(boolean isSandbox, String appKey, String appSecret) {
        if (StringUtils.areNotEmpty(appKey, appSecret)) {
        } else {
            System.out.println("appKey and appSecret is required.");
        }
        app_key = appKey;
        app_secret = appSecret;
        if (isSandbox) {
            oauthCodeUrl = BasicURL.OAuth.SANDBOX_AUTHORIZE;
            serverUrl = BasicURL.SANDBOX_SERVER;
            apiUrl = BasicURL.OpenApi.SANDBOX_Api;
        } else {
            oauthCodeUrl = BasicURL.OAuth.PRODUCTION_AUTHORIZE;
            serverUrl = BasicURL.PRODUCTION_SERVER;
            apiUrl = BasicURL.OpenApi.PRODUCTION_Api;
        }
    }

    //C业务专用
    public Config(String appKey, boolean isPPE, String appSecret) {
        if (StringUtils.areNotEmpty(appKey, appSecret)) {
        } else {
            System.out.println("appKey and appSecret is required.");
        }
        app_key = appKey;
        app_secret = appSecret;

        oauthCodeUrl = BasicURL.OAuth.PRODUCTION_AUTHORIZE;
        if (isPPE) {
            serverUrl = BasicURL.PPE_PRODUCTION_SERVER;
            apiUrl = BasicURL.OpenApi.PRODUCTION_Api_4_PPE;
        } else {
            serverUrl = BasicURL.PRODUCTION_SERVER_4_C;
            apiUrl = BasicURL.OpenApi.PRODUCTION_Api_4_C;
        }
    }

    public Config(boolean isSandbox, boolean isPPE, String appKey, String appSecret) {
        if (StringUtils.areNotEmpty(appKey, appSecret)) {
        } else {
            System.out.println("appKey and appSecret is required.");
        }
        app_key = appKey;
        app_secret = appSecret;
        if (isSandbox) {
            oauthCodeUrl = BasicURL.OAuth.SANDBOX_AUTHORIZE;
            if (isPPE) {
                serverUrl = BasicURL.PPE_SANDBOX_SERVER;
            } else {
                serverUrl = BasicURL.SANDBOX_SERVER;
            }
            apiUrl = BasicURL.OpenApi.SANDBOX_Api;
        } else {
            oauthCodeUrl = BasicURL.OAuth.PRODUCTION_AUTHORIZE;
            if (isPPE) {
                serverUrl = BasicURL.PPE_PRODUCTION_SERVER;
                apiUrl = BasicURL.OpenApi.PRODUCTION_Api_4_PPE;
            } else {
                serverUrl = BasicURL.PRODUCTION_SERVER;
                apiUrl = BasicURL.OpenApi.PRODUCTION_Api;
            }

        }
    }

    public void setLog(ElemeSdkLogger elemeSdkLogger) {
        this.elemeSdkLogger = elemeSdkLogger;
    }

    public ElemeSdkLogger getElemeSdkLogger() {
        return elemeSdkLogger;
    }

    public  void setOauthCodeUrl(String oauthCodeUrl) {
        this.oauthCodeUrl = oauthCodeUrl;
    }

    public  void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public  void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public  String getOauthCodeUrl() {
        return oauthCodeUrl;
    }

    public  String getServerUrl() {
        return serverUrl;
    }

    public  String getApiUrl() {
        return apiUrl;
    }

    public  String getApp_key() {
        return app_key;
    }

    public  String getApp_secret() {
        return app_secret;
    }

    public boolean isHttpPoolRequest() {
        return httpPoolRequest;
    }

    public void setHttpPoolRequest(boolean httpPoolRequest) {
        this.httpPoolRequest = httpPoolRequest;
    }
}
