package eleme.openapi.sdk.config;

import java.util.HashSet;
import java.util.Set;

public abstract class Constants {

    /**
     * Date默认时区
     **/
    public static final String DATE_TIMEZONE = "GMT+8";

    /**
     * TOP默认时间格式
     **/
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    /**
     * UTF-8字符集
     **/
    public static final String CHARSET_UTF8 = "UTF-8";
    /**
     * 默认流式读取缓冲区大小
     **/
    public static final int READ_BUFFER_SIZE = 1024 * 4;
    /**
     * 默认媒体类型
     **/
    public static final String MIME_TYPE_DEFAULT = "application/octet-stream";

    /**
     * oauth 请求头部Key
     */
    public static final String HEAD_OAUTH_KEY = "Authorization";

    /**
     * 返回的错误码
     */
    public static final String ERROR_RESPONSE = "error_response";

    /**
     * Oauth Signature
     */
    public static final String TOKEN_SIGN = "oauth";

    /**
     * OpenId Signature
     */
    public static final String OPENID_SIGN = "openId";

    /**
     * Oauth URL suffix
     */
    public static final String TOKEN_URL = "token";

    /**
     * OpenId Signature
     */
    public static final String OPENID_URL = "identity";

    /**
     * 允许的视频大小最大值
     */
    public static final int VIDEO_MAX_SIZE = 200 * 1024 * 1024;

    /**
     * 允许的视频后缀列表
     */
    public static final Set<String> VIDEO_EXT_LIST = new HashSet<String>();

    static {
        VIDEO_EXT_LIST.add("MP4");
        VIDEO_EXT_LIST.add("MOV");
    }
}
