package eleme.openapi.sdk.media.client;

import eleme.openapi.sdk.media.MediaFile;
import eleme.openapi.sdk.media.Result;
import eleme.openapi.sdk.media.upload.UploadClient;

import java.io.File;
import java.io.InputStream;

/**
 * @author jinli Feb 7, 2015
 */
public interface MediaClient extends UploadClient {

    /**
     * upload media file
     * 
     * @param dir 本地文件路径
     * @param name 文件名称
     * @param file 本地文件
     * @return MediaFile
     */
    Result<MediaFile> upload(String dir, String name, File file);

    /**
     * upload media file
     * 
     * @param dir 本地文件路径
     * @param name 文件名
     * @param input 文件输入流
     * @param size 文件大小
     * @return MediaFile
     */
    Result<MediaFile> upload(String dir, String name, InputStream input, long size);

}
