package eleme.openapi.sdk.media.common.http;

import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.util.Args;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * @author jinli Feb 5, 2015
 */
public class LengthInputStreamBody extends InputStreamBody {

    private long contentLength;

    public LengthInputStreamBody(InputStream in, ContentType contentType, String filename, long contentLength) {
        super(in, contentType, filename);
        this.contentLength = contentLength;
    }

    @Override
    public long getContentLength() {
        return contentLength;
    }

    @Override
    public void writeTo(final OutputStream out) throws IOException {
        Args.notNull(out, "Output stream");
        try {
            final byte[] tmp = new byte[4096 * 1024];
            int l;
            int counter = 0;
            while ((l = this.getInputStream().read(tmp)) != -1 && counter < contentLength) {
                out.write(tmp, 0, l);
                counter += l;
            }
            out.flush();
        } finally {
            this.getInputStream().close();
        }
    }
}
