package eleme.openapi.sdk.media.manage;

import eleme.openapi.sdk.media.common.EncodeUtil;
import eleme.openapi.sdk.utils.JacksonUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hyzhou.zhy. 2015/07/03.
 * <br>
 * GlobalFileResource
 * <br>
 * By specifying the Namespace Name Dir, the only file is identified under the Wantu Service.
 * Generally used in the operation which crossed Namespace, such as defined output file in file encode operation.
 */
public class GlobalFileResource implements Serializable {

    private static final long serialVersionUID = 320339774782120351L;

    private String namespace;
    private FileResource fileResource;

    public GlobalFileResource() {
        this.namespace = null;
        this.fileResource = new FileResource();
    }

    public GlobalFileResource(String dir, String name) {
        this(null, dir, name);
    }

    public GlobalFileResource(String namespace, String dir, String name) {
        this.namespace = namespace;
        this.fileResource = new FileResource(dir, name);
    }

    public String getDir() {
        return fileResource.getDir();
    }

    public void setDir(String dir) {
        this.fileResource.setDir(dir);
    }

    public String getName() {
        return fileResource.getName();
    }

    public void setName(String name) {
        this.fileResource.setName(name);
    }

    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String toResourceId() {
        List<String> jsonData = new ArrayList<String>();
        jsonData.add(this.getNamespace());
        jsonData.add(this.getDir());
        jsonData.add(this.getName());
        String jsonString = JacksonUtils.obj2json(jsonData);
        return EncodeUtil.encodeWithURLSafeBase64(jsonString);
    }
}
