package eleme.openapi.sdk.media.trace;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by huamulou on 15/12/9.
 */
public class Profiler {
    private static final ThreadLocal<Map<String, Factor>> mapThreadLocal = new ThreadLocal<Map<String, Factor>>();
    private static final ThreadLocal<Map<String, String>> kvMap = new ThreadLocal<Map<String, String>>();
    private static final ThreadLocal<Boolean> startThreadLocal = new ThreadLocal<Boolean>();


    public static Map<String, String> getKVMap() {
        if (kvMap.get() != null) {
            return kvMap.get();
        }
        synchronized (Profiler.class) {
            if (kvMap.get() != null) {
                return kvMap.get();
            }

            Map<String, String> map = new HashMap();
            kvMap.set(map);
            return map;
        }

    }


    public static Map<String, String> setKVMap() {
        return kvMap.get();
    }

    public static Boolean getStarted() {
        return startThreadLocal.get() == null ? false : startThreadLocal.get();
    }

    public static void setStarted(boolean arg) {
        startThreadLocal.set(arg);
    }

    public static Map<String, Factor> getMap() {
        return mapThreadLocal.get();
    }

    public static void setParameter(String key, Factor value) {
        Map<String, Factor> map = getMapInternal();
        map.put(key, value);
    }


    private static Map<String, Factor> getMapInternal() {
        Map<String, Factor> map = getMap();
        if (getMap() == null) {
            synchronized (Profiler.class) {
                if (getMap() == null) {
                    map = new HashMap();
                    mapThreadLocal.set(map);
                }
            }

        }
        return map;
    }

    public static Factor getParameter(String key) {
        Map<String, Factor> map = getMapInternal();
        return map.get(key);
    }


    public static void clear() {
        mapThreadLocal.remove();
        startThreadLocal.remove();
    }

    public static class Factor {
        private long start;
        private long end;

        public Factor() {

        }

        public Factor(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public Factor(long start) {
            this.start = start;
        }

        public long getStart() {
            return start;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public long getEnd() {
            return end;
        }

        public void setEnd(long end) {
            this.end = end;
        }

        public long getInterval() {
            if (start == 0 || end == 0) {
                return -1;
            }
            return end - start;
        }
    }

}
