package eleme.openapi.sdk.media.upload;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author jinli
 */
public class MultipartCompleteRequest extends BaseUploadRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    private String dir;                                                 // media file dir
    private String name;                                                // media file name
    private String id;                                                  // id
    private String uploadId;                                            // upload id
    private String md5;                                                 // md5 of file content
    private List<PartInfo> parts = new ArrayList<PartInfo>();           // block part infomation

    private Map<String, String> metas = new HashMap<String, String>();  // meta vars
    private Map<String, String> vars = new HashMap<String, String>();   // custom vars
    private Map<String, Object> extendPars = new HashMap<String, Object>();   // custom extend parameters, set in http body, not be persisted

    public MultipartCompleteRequest() {
    }

    public MultipartCompleteRequest(String token) {
        super(token);
    }

    public MultipartCompleteRequest(UploadPolicy uploadPolicy) {
        super(uploadPolicy);
    }

    public String getDir() {
        return dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUploadId() {
        return uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public List<PartInfo> getParts() {
        return parts;
    }

    public void setParts(List<PartInfo> parts) {
        this.parts = parts;
    }

    public Map<String, String> getMetas() {
        return metas;
    }

    public void setMetas(Map<String, String> metas) {
        this.metas = metas;
    }

    public Map<String, Object> getExtendPars() {
        return extendPars;
    }

    public void setExtendPars(Map<String, Object> extendPars) {
        this.extendPars = extendPars;
    }

    public Map<String, String> getVars() {
        return vars;
    }

    public void setVars(Map<String, String> vars) {
        this.vars = vars;
    }

    public String getMd5() {
        return md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    /**
     * 块信息
     *
     * @author jinli
     */
    public static class PartInfo implements Serializable {

        private static final long serialVersionUID = 1L;

        private int partNumber;
        private String eTag;

        public PartInfo() {
        }

        public PartInfo(int partNumber, String eTag) {
            this.partNumber = partNumber;
            this.eTag = eTag;
        }

        public int getPartNumber() {
            return partNumber;
        }

        public void setPartNumber(int partNumber) {
            this.partNumber = partNumber;
        }

        public String geteTag() {
            return eTag;
        }

        public void seteTag(String eTag) {
            this.eTag = eTag;
        }

    }

}
