package eleme.openapi.sdk.media.upload;

import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * @author jinli
 */
public class MultipartUploadRequest extends BaseUploadRequest implements Serializable {

    private static final long serialVersionUID = -1891030390087066968L;

    private String dir;                                                 // media file dir
    private String name;                                                // media file name
    private String id;                                                  // id
    private String uploadId;                                            // upload id
    private Integer partNumber;                                         // part number
    private String md5;                                                 // md5 of file content
    private InputStream content;                                        // file content
    private long contentSize;                                           // file content size

    private Map<String, String> metas = new HashMap<String, String>();  // meta vars
    private Map<String, String> vars = new HashMap<String, String>();   // custom vars
    private Map<String, Object> extendPars = new HashMap<String, Object>();   // custom extend parameters, set in http body, not be persisted

    public MultipartUploadRequest() {
    }

    public MultipartUploadRequest(String token) {
        super(token);
    }

    public MultipartUploadRequest(UploadPolicy uploadPolicy) {
        super(uploadPolicy);
    }

    public String getDir() {
        return dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUploadId() {
        return uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public Map<String, String> getMetas() {
        return metas;
    }

    public void setMetas(Map<String, String> metas) {
        this.metas = metas;
    }

    public Map<String, String> getVars() {
        return vars;
    }

    public void setVars(Map<String, String> vars) {
        this.vars = vars;
    }

    public Map<String, Object> getExtendPars() {
        return extendPars;
    }

    public void setExtendPars(Map<String, Object> extendPars) {
        this.extendPars = extendPars;
    }

    public Integer getPartNumber() {
        return partNumber;
    }

    public void setPartNumber(Integer partNumber) {
        this.partNumber = partNumber;
    }

    public String getMd5() {
        return md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public InputStream getContent() {
        return content;
    }

    public void setContent(InputStream content) {
        this.content = content;
    }

    public Long getContentSize() {
        return contentSize;
    }

    public void setContentSize(Long contentSize) {
        this.contentSize = contentSize;
    }
}
