package eleme.openapi.sdk.oauth.request;

import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.config.Constants;
import eleme.openapi.sdk.oauth.BaseOAuthRequest;
import eleme.openapi.sdk.oauth.response.OpenId;

import java.util.Map;

public class ServerOpenIdRequest extends BaseOAuthRequest<OpenId> {
    private Config context;
    public ServerOpenIdRequest(Config context) {
        this.context = context;
    }
    private String code;
    private String redirectUri;

    @Override
    public Class<OpenId> getResponseClass() {
        return OpenId.class;
    }

    @Override
    public Map<String, String> getHeaderMap() {
        setAuthorization(context.getApp_key(), context.getApp_secret(), Constants.OPENID_SIGN);
        return super.headerMap;
    }

    @Override
    public Map<String, String> getBodyMap() {
        putBodyParam("grant_type", "authorization_code");
        putBodyParam("code", this.code);
        putBodyParam("redirect_uri", this.redirectUri);
        putBodyParam("client_id", context.getApp_key());
        return super.bodyMap;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

}
