/*
 * Copyright (c) 2015, 2018, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, version 2.0, as published by the
 * Free Software Foundation.
 *
 * This program is also distributed with certain software (including but not
 * limited to OpenSSL) that is licensed under separate terms, as designated in a
 * particular file or component or in included license documentation. The
 * authors of MySQL hereby grant you an additional permission to link the
 * program and your derivative works with the separately licensed software that
 * they have included with MySQL.
 *
 * Without limiting anything contained in the foregoing, this file, which is
 * part of MySQL Connector/J, is also subject to the Universal FOSS Exception,
 * version 1.0, a copy of which can be found at
 * http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License, version 2.0,
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

package com.mysql.cj.x.protobuf;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: mysqlx_expect.proto

public final class MysqlxExpect {
  private MysqlxExpect() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  public interface OpenOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Expect.Open)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .Mysqlx.Expect.Open.CtxOperation op = 1 [default = EXPECT_CTX_COPY_PREV];</code>
     */
    boolean hasOp();
    /**
     * <code>optional .Mysqlx.Expect.Open.CtxOperation op = 1 [default = EXPECT_CTX_COPY_PREV];</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpect.Open.CtxOperation getOp();

    /**
     * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition> 
        getCondList();
    /**
     * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition getCond(int index);
    /**
     * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
     */
    int getCondCount();
    /**
     * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpect.Open.ConditionOrBuilder> 
        getCondOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxExpect.Open.ConditionOrBuilder getCondOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code Mysqlx.Expect.Open}
   *
   * <pre>
   * open an Expect block and set/unset the conditions that have to be fulfilled
   * if any of the conditions fail, all enclosed messages will fail with
   * a Mysqlx.Error message.
   * :returns: :protobuf:msg:`Mysqlx::Ok` on success, :protobuf:msg:`Mysqlx::Error` on error
   * </pre>
   */
  public static final class Open extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Expect.Open)
      OpenOrBuilder {
    // Use Open.newBuilder() to construct.
    private Open(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Open(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Open defaultInstance;
    public static Open getDefaultInstance() {
      return defaultInstance;
    }

    public Open getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Open(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxExpect.Open.CtxOperation value = com.mysql.cj.x.protobuf.MysqlxExpect.Open.CtxOperation.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                op_ = value;
              }
              break;
            }
            case 18: {
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                cond_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition>();
                mutable_bitField0_ |= 0x00000002;
              }
              cond_.add(input.readMessage(com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          cond_ = java.util.Collections.unmodifiableList(cond_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxExpect.internal_static_Mysqlx_Expect_Open_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxExpect.internal_static_Mysqlx_Expect_Open_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxExpect.Open.class, com.mysql.cj.x.protobuf.MysqlxExpect.Open.Builder.class);
    }

    public static com.google.protobuf.Parser<Open> PARSER =
        new com.google.protobuf.AbstractParser<Open>() {
      public Open parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Open(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Open> getParserForType() {
      return PARSER;
    }

    /**
     * Protobuf enum {@code Mysqlx.Expect.Open.CtxOperation}
     */
    public enum CtxOperation
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>EXPECT_CTX_COPY_PREV = 0;</code>
       *
       * <pre>
       * copy the operations from the parent Expect-block
       * </pre>
       */
      EXPECT_CTX_COPY_PREV(0, 0),
      /**
       * <code>EXPECT_CTX_EMPTY = 1;</code>
       *
       * <pre>
       * start with a empty set of operations
       * </pre>
       */
      EXPECT_CTX_EMPTY(1, 1),
      ;

      /**
       * <code>EXPECT_CTX_COPY_PREV = 0;</code>
       *
       * <pre>
       * copy the operations from the parent Expect-block
       * </pre>
       */
      public static final int EXPECT_CTX_COPY_PREV_VALUE = 0;
      /**
       * <code>EXPECT_CTX_EMPTY = 1;</code>
       *
       * <pre>
       * start with a empty set of operations
       * </pre>
       */
      public static final int EXPECT_CTX_EMPTY_VALUE = 1;


      public final int getNumber() { return value; }

      public static CtxOperation valueOf(int value) {
        switch (value) {
          case 0: return EXPECT_CTX_COPY_PREV;
          case 1: return EXPECT_CTX_EMPTY;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<CtxOperation>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static com.google.protobuf.Internal.EnumLiteMap<CtxOperation>
          internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CtxOperation>() {
              public CtxOperation findValueByNumber(int number) {
                return CtxOperation.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpect.Open.getDescriptor().getEnumTypes().get(0);
      }

      private static final CtxOperation[] VALUES = values();

      public static CtxOperation valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private CtxOperation(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Expect.Open.CtxOperation)
    }

    public interface ConditionOrBuilder extends
        // @@protoc_insertion_point(interface_extends:Mysqlx.Expect.Open.Condition)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <code>required uint32 condition_key = 1;</code>
       */
      boolean hasConditionKey();
      /**
       * <code>required uint32 condition_key = 1;</code>
       */
      int getConditionKey();

      /**
       * <code>optional bytes condition_value = 2;</code>
       */
      boolean hasConditionValue();
      /**
       * <code>optional bytes condition_value = 2;</code>
       */
      com.google.protobuf.ByteString getConditionValue();

      /**
       * <code>optional .Mysqlx.Expect.Open.Condition.ConditionOperation op = 3 [default = EXPECT_OP_SET];</code>
       */
      boolean hasOp();
      /**
       * <code>optional .Mysqlx.Expect.Open.Condition.ConditionOperation op = 3 [default = EXPECT_OP_SET];</code>
       */
      com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.ConditionOperation getOp();
    }
    /**
     * Protobuf type {@code Mysqlx.Expect.Open.Condition}
     */
    public static final class Condition extends
        com.google.protobuf.GeneratedMessage implements
        // @@protoc_insertion_point(message_implements:Mysqlx.Expect.Open.Condition)
        ConditionOrBuilder {
      // Use Condition.newBuilder() to construct.
      private Condition(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
        this.unknownFields = builder.getUnknownFields();
      }
      private Condition(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

      private static final Condition defaultInstance;
      public static Condition getDefaultInstance() {
        return defaultInstance;
      }

      public Condition getDefaultInstanceForType() {
        return defaultInstance;
      }

      private final com.google.protobuf.UnknownFieldSet unknownFields;
      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
          getUnknownFields() {
        return this.unknownFields;
      }
      private Condition(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        initFields();
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!parseUnknownField(input, unknownFields,
                                       extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
              case 8: {
                bitField0_ |= 0x00000001;
                conditionKey_ = input.readUInt32();
                break;
              }
              case 18: {
                bitField0_ |= 0x00000002;
                conditionValue_ = input.readBytes();
                break;
              }
              case 24: {
                int rawValue = input.readEnum();
                com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.ConditionOperation value = com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.ConditionOperation.valueOf(rawValue);
                if (value == null) {
                  unknownFields.mergeVarintField(3, rawValue);
                } else {
                  bitField0_ |= 0x00000004;
                  op_ = value;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e.getMessage()).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpect.internal_static_Mysqlx_Expect_Open_Condition_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpect.internal_static_Mysqlx_Expect_Open_Condition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.class, com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.Builder.class);
      }

      public static com.google.protobuf.Parser<Condition> PARSER =
          new com.google.protobuf.AbstractParser<Condition>() {
        public Condition parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Condition(input, extensionRegistry);
        }
      };

      @java.lang.Override
      public com.google.protobuf.Parser<Condition> getParserForType() {
        return PARSER;
      }

      /**
       * Protobuf enum {@code Mysqlx.Expect.Open.Condition.Key}
       */
      public enum Key
          implements com.google.protobuf.ProtocolMessageEnum {
        /**
         * <code>EXPECT_NO_ERROR = 1;</code>
         *
         * <pre>
         * Change error propagation behaviour
         * </pre>
         */
        EXPECT_NO_ERROR(0, 1),
        /**
         * <code>EXPECT_FIELD_EXIST = 2;</code>
         *
         * <pre>
         * Check if X Protocol field exists
         * </pre>
         */
        EXPECT_FIELD_EXIST(1, 2),
        /**
         * <code>EXPECT_DOCID_GENERATED = 3;</code>
         *
         * <pre>
         * Check if X Protocol support document _id generation
         * </pre>
         */
        EXPECT_DOCID_GENERATED(2, 3),
        ;

        /**
         * <code>EXPECT_NO_ERROR = 1;</code>
         *
         * <pre>
         * Change error propagation behaviour
         * </pre>
         */
        public static final int EXPECT_NO_ERROR_VALUE = 1;
        /**
         * <code>EXPECT_FIELD_EXIST = 2;</code>
         *
         * <pre>
         * Check if X Protocol field exists
         * </pre>
         */
        public static final int EXPECT_FIELD_EXIST_VALUE = 2;
        /**
         * <code>EXPECT_DOCID_GENERATED = 3;</code>
         *
         * <pre>
         * Check if X Protocol support document _id generation
         * </pre>
         */
        public static final int EXPECT_DOCID_GENERATED_VALUE = 3;


        public final int getNumber() { return value; }

        public static Key valueOf(int value) {
          switch (value) {
            case 1: return EXPECT_NO_ERROR;
            case 2: return EXPECT_FIELD_EXIST;
            case 3: return EXPECT_DOCID_GENERATED;
            default: return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<Key>
            internalGetValueMap() {
          return internalValueMap;
        }
        private static com.google.protobuf.Internal.EnumLiteMap<Key>
            internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<Key>() {
                public Key findValueByNumber(int number) {
                  return Key.valueOf(number);
                }
              };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor
            getValueDescriptor() {
          return getDescriptor().getValues().get(index);
        }
        public final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptorForType() {
          return getDescriptor();
        }
        public static final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptor() {
          return com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.getDescriptor().getEnumTypes().get(0);
        }

        private static final Key[] VALUES = values();

        public static Key valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
              "EnumValueDescriptor is not for this type.");
          }
          return VALUES[desc.getIndex()];
        }

        private final int index;
        private final int value;

        private Key(int index, int value) {
          this.index = index;
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:Mysqlx.Expect.Open.Condition.Key)
      }

      /**
       * Protobuf enum {@code Mysqlx.Expect.Open.Condition.ConditionOperation}
       */
      public enum ConditionOperation
          implements com.google.protobuf.ProtocolMessageEnum {
        /**
         * <code>EXPECT_OP_SET = 0;</code>
         *
         * <pre>
         * set the condition
         * set, if not set
         * overwrite, if set
         * </pre>
         */
        EXPECT_OP_SET(0, 0),
        /**
         * <code>EXPECT_OP_UNSET = 1;</code>
         *
         * <pre>
         * unset the condition
         * </pre>
         */
        EXPECT_OP_UNSET(1, 1),
        ;

        /**
         * <code>EXPECT_OP_SET = 0;</code>
         *
         * <pre>
         * set the condition
         * set, if not set
         * overwrite, if set
         * </pre>
         */
        public static final int EXPECT_OP_SET_VALUE = 0;
        /**
         * <code>EXPECT_OP_UNSET = 1;</code>
         *
         * <pre>
         * unset the condition
         * </pre>
         */
        public static final int EXPECT_OP_UNSET_VALUE = 1;


        public final int getNumber() { return value; }

        public static ConditionOperation valueOf(int value) {
          switch (value) {
            case 0: return EXPECT_OP_SET;
            case 1: return EXPECT_OP_UNSET;
            default: return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<ConditionOperation>
            internalGetValueMap() {
          return internalValueMap;
        }
        private static com.google.protobuf.Internal.EnumLiteMap<ConditionOperation>
            internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<ConditionOperation>() {
                public ConditionOperation findValueByNumber(int number) {
                  return ConditionOperation.valueOf(number);
                }
              };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor
            getValueDescriptor() {
          return getDescriptor().getValues().get(index);
        }
        public final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptorForType() {
          return getDescriptor();
        }
        public static final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptor() {
          return com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.getDescriptor().getEnumTypes().get(1);
        }

        private static final ConditionOperation[] VALUES = values();

        public static ConditionOperation valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
              "EnumValueDescriptor is not for this type.");
          }
          return VALUES[desc.getIndex()];
        }

        private final int index;
        private final int value;

        private ConditionOperation(int index, int value) {
          this.index = index;
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:Mysqlx.Expect.Open.Condition.ConditionOperation)
      }

      private int bitField0_;
      public static final int CONDITION_KEY_FIELD_NUMBER = 1;
      private int conditionKey_;
      /**
       * <code>required uint32 condition_key = 1;</code>
       */
      public boolean hasConditionKey() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required uint32 condition_key = 1;</code>
       */
      public int getConditionKey() {
        return conditionKey_;
      }

      public static final int CONDITION_VALUE_FIELD_NUMBER = 2;
      private com.google.protobuf.ByteString conditionValue_;
      /**
       * <code>optional bytes condition_value = 2;</code>
       */
      public boolean hasConditionValue() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional bytes condition_value = 2;</code>
       */
      public com.google.protobuf.ByteString getConditionValue() {
        return conditionValue_;
      }

      public static final int OP_FIELD_NUMBER = 3;
      private com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.ConditionOperation op_;
      /**
       * <code>optional .Mysqlx.Expect.Open.Condition.ConditionOperation op = 3 [default = EXPECT_OP_SET];</code>
       */
      public boolean hasOp() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional .Mysqlx.Expect.Open.Condition.ConditionOperation op = 3 [default = EXPECT_OP_SET];</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.ConditionOperation getOp() {
        return op_;
      }

      private void initFields() {
        conditionKey_ = 0;
        conditionValue_ = com.google.protobuf.ByteString.EMPTY;
        op_ = com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.ConditionOperation.EXPECT_OP_SET;
      }
      private byte memoizedIsInitialized = -1;
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasConditionKey()) {
          memoizedIsInitialized = 0;
          return false;
        }
        memoizedIsInitialized = 1;
        return true;
      }

      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        getSerializedSize();
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          output.writeUInt32(1, conditionKey_);
        }
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          output.writeBytes(2, conditionValue_);
        }
        if (((bitField0_ & 0x00000004) == 0x00000004)) {
          output.writeEnum(3, op_.getNumber());
        }
        getUnknownFields().writeTo(output);
      }

      private int memoizedSerializedSize = -1;
      public int getSerializedSize() {
        int size = memoizedSerializedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          size += com.google.protobuf.CodedOutputStream
            .computeUInt32Size(1, conditionKey_);
        }
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          size += com.google.protobuf.CodedOutputStream
            .computeBytesSize(2, conditionValue_);
        }
        if (((bitField0_ & 0x00000004) == 0x00000004)) {
          size += com.google.protobuf.CodedOutputStream
            .computeEnumSize(3, op_.getNumber());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSerializedSize = size;
        return size;
      }

      private static final long serialVersionUID = 0L;
      @java.lang.Override
      protected java.lang.Object writeReplace()
          throws java.io.ObjectStreamException {
        return super.writeReplace();
      }

      public static com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return PARSER.parseFrom(input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return PARSER.parseFrom(input, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return PARSER.parseDelimitedFrom(input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return PARSER.parseDelimitedFrom(input, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return PARSER.parseFrom(input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return PARSER.parseFrom(input, extensionRegistry);
      }

      public static Builder newBuilder() { return Builder.create(); }
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition prototype) {
        return newBuilder().mergeFrom(prototype);
      }
      public Builder toBuilder() { return newBuilder(this); }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code Mysqlx.Expect.Open.Condition}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessage.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:Mysqlx.Expect.Open.Condition)
          com.mysql.cj.x.protobuf.MysqlxExpect.Open.ConditionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.mysql.cj.x.protobuf.MysqlxExpect.internal_static_Mysqlx_Expect_Open_Condition_descriptor;
        }

        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.mysql.cj.x.protobuf.MysqlxExpect.internal_static_Mysqlx_Expect_Open_Condition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.class, com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.Builder.class);
        }

        // Construct using com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          }
        }
        private static Builder create() {
          return new Builder();
        }

        public Builder clear() {
          super.clear();
          conditionKey_ = 0;
          bitField0_ = (bitField0_ & ~0x00000001);
          conditionValue_ = com.google.protobuf.ByteString.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000002);
          op_ = com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.ConditionOperation.EXPECT_OP_SET;
          bitField0_ = (bitField0_ & ~0x00000004);
          return this;
        }

        public Builder clone() {
          return create().mergeFrom(buildPartial());
        }

        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.mysql.cj.x.protobuf.MysqlxExpect.internal_static_Mysqlx_Expect_Open_Condition_descriptor;
        }

        public com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition getDefaultInstanceForType() {
          return com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.getDefaultInstance();
        }

        public com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition build() {
          com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        public com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition buildPartial() {
          com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition result = new com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
            to_bitField0_ |= 0x00000001;
          }
          result.conditionKey_ = conditionKey_;
          if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
            to_bitField0_ |= 0x00000002;
          }
          result.conditionValue_ = conditionValue_;
          if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
            to_bitField0_ |= 0x00000004;
          }
          result.op_ = op_;
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition) {
            return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition other) {
          if (other == com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.getDefaultInstance()) return this;
          if (other.hasConditionKey()) {
            setConditionKey(other.getConditionKey());
          }
          if (other.hasConditionValue()) {
            setConditionValue(other.getConditionValue());
          }
          if (other.hasOp()) {
            setOp(other.getOp());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          return this;
        }

        public final boolean isInitialized() {
          if (!hasConditionKey()) {
            
            return false;
          }
          return true;
        }

        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition) e.getUnfinishedMessage();
            throw e;
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private int conditionKey_ ;
        /**
         * <code>required uint32 condition_key = 1;</code>
         */
        public boolean hasConditionKey() {
          return ((bitField0_ & 0x00000001) == 0x00000001);
        }
        /**
         * <code>required uint32 condition_key = 1;</code>
         */
        public int getConditionKey() {
          return conditionKey_;
        }
        /**
         * <code>required uint32 condition_key = 1;</code>
         */
        public Builder setConditionKey(int value) {
          bitField0_ |= 0x00000001;
          conditionKey_ = value;
          onChanged();
          return this;
        }
        /**
         * <code>required uint32 condition_key = 1;</code>
         */
        public Builder clearConditionKey() {
          bitField0_ = (bitField0_ & ~0x00000001);
          conditionKey_ = 0;
          onChanged();
          return this;
        }

        private com.google.protobuf.ByteString conditionValue_ = com.google.protobuf.ByteString.EMPTY;
        /**
         * <code>optional bytes condition_value = 2;</code>
         */
        public boolean hasConditionValue() {
          return ((bitField0_ & 0x00000002) == 0x00000002);
        }
        /**
         * <code>optional bytes condition_value = 2;</code>
         */
        public com.google.protobuf.ByteString getConditionValue() {
          return conditionValue_;
        }
        /**
         * <code>optional bytes condition_value = 2;</code>
         */
        public Builder setConditionValue(com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          conditionValue_ = value;
          onChanged();
          return this;
        }
        /**
         * <code>optional bytes condition_value = 2;</code>
         */
        public Builder clearConditionValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          conditionValue_ = getDefaultInstance().getConditionValue();
          onChanged();
          return this;
        }

        private com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.ConditionOperation op_ = com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.ConditionOperation.EXPECT_OP_SET;
        /**
         * <code>optional .Mysqlx.Expect.Open.Condition.ConditionOperation op = 3 [default = EXPECT_OP_SET];</code>
         */
        public boolean hasOp() {
          return ((bitField0_ & 0x00000004) == 0x00000004);
        }
        /**
         * <code>optional .Mysqlx.Expect.Open.Condition.ConditionOperation op = 3 [default = EXPECT_OP_SET];</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.ConditionOperation getOp() {
          return op_;
        }
        /**
         * <code>optional .Mysqlx.Expect.Open.Condition.ConditionOperation op = 3 [default = EXPECT_OP_SET];</code>
         */
        public Builder setOp(com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.ConditionOperation value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000004;
          op_ = value;
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Expect.Open.Condition.ConditionOperation op = 3 [default = EXPECT_OP_SET];</code>
         */
        public Builder clearOp() {
          bitField0_ = (bitField0_ & ~0x00000004);
          op_ = com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.ConditionOperation.EXPECT_OP_SET;
          onChanged();
          return this;
        }

        // @@protoc_insertion_point(builder_scope:Mysqlx.Expect.Open.Condition)
      }

      static {
        defaultInstance = new Condition(true);
        defaultInstance.initFields();
      }

      // @@protoc_insertion_point(class_scope:Mysqlx.Expect.Open.Condition)
    }

    private int bitField0_;
    public static final int OP_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.MysqlxExpect.Open.CtxOperation op_;
    /**
     * <code>optional .Mysqlx.Expect.Open.CtxOperation op = 1 [default = EXPECT_CTX_COPY_PREV];</code>
     */
    public boolean hasOp() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .Mysqlx.Expect.Open.CtxOperation op = 1 [default = EXPECT_CTX_COPY_PREV];</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpect.Open.CtxOperation getOp() {
      return op_;
    }

    public static final int COND_FIELD_NUMBER = 2;
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition> cond_;
    /**
     * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
     */
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition> getCondList() {
      return cond_;
    }
    /**
     * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
     */
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpect.Open.ConditionOrBuilder> 
        getCondOrBuilderList() {
      return cond_;
    }
    /**
     * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
     */
    public int getCondCount() {
      return cond_.size();
    }
    /**
     * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition getCond(int index) {
      return cond_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxExpect.Open.ConditionOrBuilder getCondOrBuilder(
        int index) {
      return cond_.get(index);
    }

    private void initFields() {
      op_ = com.mysql.cj.x.protobuf.MysqlxExpect.Open.CtxOperation.EXPECT_CTX_COPY_PREV;
      cond_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getCondCount(); i++) {
        if (!getCond(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, op_.getNumber());
      }
      for (int i = 0; i < cond_.size(); i++) {
        output.writeMessage(2, cond_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, op_.getNumber());
      }
      for (int i = 0; i < cond_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, cond_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpect.Open parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpect.Open parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpect.Open parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpect.Open parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpect.Open parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpect.Open parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpect.Open parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpect.Open parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpect.Open parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpect.Open parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpect.Open prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Expect.Open}
     *
     * <pre>
     * open an Expect block and set/unset the conditions that have to be fulfilled
     * if any of the conditions fail, all enclosed messages will fail with
     * a Mysqlx.Error message.
     * :returns: :protobuf:msg:`Mysqlx::Ok` on success, :protobuf:msg:`Mysqlx::Error` on error
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Expect.Open)
        com.mysql.cj.x.protobuf.MysqlxExpect.OpenOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpect.internal_static_Mysqlx_Expect_Open_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpect.internal_static_Mysqlx_Expect_Open_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpect.Open.class, com.mysql.cj.x.protobuf.MysqlxExpect.Open.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxExpect.Open.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getCondFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        op_ = com.mysql.cj.x.protobuf.MysqlxExpect.Open.CtxOperation.EXPECT_CTX_COPY_PREV;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (condBuilder_ == null) {
          cond_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          condBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpect.internal_static_Mysqlx_Expect_Open_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpect.Open getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpect.Open.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxExpect.Open build() {
        com.mysql.cj.x.protobuf.MysqlxExpect.Open result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpect.Open buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxExpect.Open result = new com.mysql.cj.x.protobuf.MysqlxExpect.Open(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.op_ = op_;
        if (condBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            cond_ = java.util.Collections.unmodifiableList(cond_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.cond_ = cond_;
        } else {
          result.cond_ = condBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpect.Open) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpect.Open)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpect.Open other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxExpect.Open.getDefaultInstance()) return this;
        if (other.hasOp()) {
          setOp(other.getOp());
        }
        if (condBuilder_ == null) {
          if (!other.cond_.isEmpty()) {
            if (cond_.isEmpty()) {
              cond_ = other.cond_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureCondIsMutable();
              cond_.addAll(other.cond_);
            }
            onChanged();
          }
        } else {
          if (!other.cond_.isEmpty()) {
            if (condBuilder_.isEmpty()) {
              condBuilder_.dispose();
              condBuilder_ = null;
              cond_ = other.cond_;
              bitField0_ = (bitField0_ & ~0x00000002);
              condBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getCondFieldBuilder() : null;
            } else {
              condBuilder_.addAllMessages(other.cond_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        for (int i = 0; i < getCondCount(); i++) {
          if (!getCond(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxExpect.Open parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxExpect.Open) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxExpect.Open.CtxOperation op_ = com.mysql.cj.x.protobuf.MysqlxExpect.Open.CtxOperation.EXPECT_CTX_COPY_PREV;
      /**
       * <code>optional .Mysqlx.Expect.Open.CtxOperation op = 1 [default = EXPECT_CTX_COPY_PREV];</code>
       */
      public boolean hasOp() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .Mysqlx.Expect.Open.CtxOperation op = 1 [default = EXPECT_CTX_COPY_PREV];</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpect.Open.CtxOperation getOp() {
        return op_;
      }
      /**
       * <code>optional .Mysqlx.Expect.Open.CtxOperation op = 1 [default = EXPECT_CTX_COPY_PREV];</code>
       */
      public Builder setOp(com.mysql.cj.x.protobuf.MysqlxExpect.Open.CtxOperation value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        op_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Expect.Open.CtxOperation op = 1 [default = EXPECT_CTX_COPY_PREV];</code>
       */
      public Builder clearOp() {
        bitField0_ = (bitField0_ & ~0x00000001);
        op_ = com.mysql.cj.x.protobuf.MysqlxExpect.Open.CtxOperation.EXPECT_CTX_COPY_PREV;
        onChanged();
        return this;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition> cond_ =
        java.util.Collections.emptyList();
      private void ensureCondIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          cond_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition>(cond_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition, com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.Builder, com.mysql.cj.x.protobuf.MysqlxExpect.Open.ConditionOrBuilder> condBuilder_;

      /**
       * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition> getCondList() {
        if (condBuilder_ == null) {
          return java.util.Collections.unmodifiableList(cond_);
        } else {
          return condBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
       */
      public int getCondCount() {
        if (condBuilder_ == null) {
          return cond_.size();
        } else {
          return condBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition getCond(int index) {
        if (condBuilder_ == null) {
          return cond_.get(index);
        } else {
          return condBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
       */
      public Builder setCond(
          int index, com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition value) {
        if (condBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCondIsMutable();
          cond_.set(index, value);
          onChanged();
        } else {
          condBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
       */
      public Builder setCond(
          int index, com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.Builder builderForValue) {
        if (condBuilder_ == null) {
          ensureCondIsMutable();
          cond_.set(index, builderForValue.build());
          onChanged();
        } else {
          condBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
       */
      public Builder addCond(com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition value) {
        if (condBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCondIsMutable();
          cond_.add(value);
          onChanged();
        } else {
          condBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
       */
      public Builder addCond(
          int index, com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition value) {
        if (condBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCondIsMutable();
          cond_.add(index, value);
          onChanged();
        } else {
          condBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
       */
      public Builder addCond(
          com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.Builder builderForValue) {
        if (condBuilder_ == null) {
          ensureCondIsMutable();
          cond_.add(builderForValue.build());
          onChanged();
        } else {
          condBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
       */
      public Builder addCond(
          int index, com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.Builder builderForValue) {
        if (condBuilder_ == null) {
          ensureCondIsMutable();
          cond_.add(index, builderForValue.build());
          onChanged();
        } else {
          condBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
       */
      public Builder addAllCond(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition> values) {
        if (condBuilder_ == null) {
          ensureCondIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, cond_);
          onChanged();
        } else {
          condBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
       */
      public Builder clearCond() {
        if (condBuilder_ == null) {
          cond_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          condBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
       */
      public Builder removeCond(int index) {
        if (condBuilder_ == null) {
          ensureCondIsMutable();
          cond_.remove(index);
          onChanged();
        } else {
          condBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.Builder getCondBuilder(
          int index) {
        return getCondFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpect.Open.ConditionOrBuilder getCondOrBuilder(
          int index) {
        if (condBuilder_ == null) {
          return cond_.get(index);  } else {
          return condBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxExpect.Open.ConditionOrBuilder> 
           getCondOrBuilderList() {
        if (condBuilder_ != null) {
          return condBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(cond_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.Builder addCondBuilder() {
        return getCondFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.Builder addCondBuilder(
          int index) {
        return getCondFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Expect.Open.Condition cond = 2;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.Builder> 
           getCondBuilderList() {
        return getCondFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition, com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.Builder, com.mysql.cj.x.protobuf.MysqlxExpect.Open.ConditionOrBuilder> 
          getCondFieldBuilder() {
        if (condBuilder_ == null) {
          condBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition, com.mysql.cj.x.protobuf.MysqlxExpect.Open.Condition.Builder, com.mysql.cj.x.protobuf.MysqlxExpect.Open.ConditionOrBuilder>(
                  cond_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          cond_ = null;
        }
        return condBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Expect.Open)
    }

    static {
      defaultInstance = new Open(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Expect.Open)
  }

  public interface CloseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Expect.Close)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * Protobuf type {@code Mysqlx.Expect.Close}
   *
   * <pre>
   * close a Expect block
   * closing a Expect block restores the state of the previous Expect block
   * for the following messages
   * :returns: :protobuf:msg:`Mysqlx::Ok` on success, :protobuf:msg:`Mysqlx::Error` on error
   * </pre>
   */
  public static final class Close extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Expect.Close)
      CloseOrBuilder {
    // Use Close.newBuilder() to construct.
    private Close(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Close(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Close defaultInstance;
    public static Close getDefaultInstance() {
      return defaultInstance;
    }

    public Close getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Close(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxExpect.internal_static_Mysqlx_Expect_Close_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxExpect.internal_static_Mysqlx_Expect_Close_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxExpect.Close.class, com.mysql.cj.x.protobuf.MysqlxExpect.Close.Builder.class);
    }

    public static com.google.protobuf.Parser<Close> PARSER =
        new com.google.protobuf.AbstractParser<Close>() {
      public Close parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Close(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Close> getParserForType() {
      return PARSER;
    }

    private void initFields() {
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxExpect.Close parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpect.Close parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpect.Close parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpect.Close parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpect.Close parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpect.Close parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpect.Close parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpect.Close parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpect.Close parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxExpect.Close parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxExpect.Close prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Expect.Close}
     *
     * <pre>
     * close a Expect block
     * closing a Expect block restores the state of the previous Expect block
     * for the following messages
     * :returns: :protobuf:msg:`Mysqlx::Ok` on success, :protobuf:msg:`Mysqlx::Error` on error
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Expect.Close)
        com.mysql.cj.x.protobuf.MysqlxExpect.CloseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxExpect.internal_static_Mysqlx_Expect_Close_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxExpect.internal_static_Mysqlx_Expect_Close_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxExpect.Close.class, com.mysql.cj.x.protobuf.MysqlxExpect.Close.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxExpect.Close.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpect.internal_static_Mysqlx_Expect_Close_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpect.Close getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxExpect.Close.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxExpect.Close build() {
        com.mysql.cj.x.protobuf.MysqlxExpect.Close result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxExpect.Close buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxExpect.Close result = new com.mysql.cj.x.protobuf.MysqlxExpect.Close(this);
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxExpect.Close) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxExpect.Close)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxExpect.Close other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxExpect.Close.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxExpect.Close parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxExpect.Close) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Expect.Close)
    }

    static {
      defaultInstance = new Close(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Expect.Close)
  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expect_Open_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expect_Open_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expect_Open_Condition_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expect_Open_Condition_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Expect_Close_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Expect_Close_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\023mysqlx_expect.proto\022\rMysqlx.Expect\032\014my" +
      "sqlx.proto\"\326\003\n\004Open\022B\n\002op\030\001 \001(\0162 .Mysqlx" +
      ".Expect.Open.CtxOperation:\024EXPECT_CTX_CO" +
      "PY_PREV\022+\n\004cond\030\002 \003(\0132\035.Mysqlx.Expect.Op" +
      "en.Condition\032\226\002\n\tCondition\022\025\n\rcondition_" +
      "key\030\001 \002(\r\022\027\n\017condition_value\030\002 \001(\014\022K\n\002op" +
      "\030\003 \001(\01620.Mysqlx.Expect.Open.Condition.Co" +
      "nditionOperation:\rEXPECT_OP_SET\"N\n\003Key\022\023" +
      "\n\017EXPECT_NO_ERROR\020\001\022\026\n\022EXPECT_FIELD_EXIS" +
      "T\020\002\022\032\n\026EXPECT_DOCID_GENERATED\020\003\"<\n\022Condi",
      "tionOperation\022\021\n\rEXPECT_OP_SET\020\000\022\023\n\017EXPE" +
      "CT_OP_UNSET\020\001\">\n\014CtxOperation\022\030\n\024EXPECT_" +
      "CTX_COPY_PREV\020\000\022\024\n\020EXPECT_CTX_EMPTY\020\001:\004\210" +
      "\3520\030\"\r\n\005Close:\004\210\3520\031B\031\n\027com.mysql.cj.x.pro" +
      "tobuf"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          com.mysql.cj.x.protobuf.Mysqlx.getDescriptor(),
        }, assigner);
    internal_static_Mysqlx_Expect_Open_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Mysqlx_Expect_Open_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expect_Open_descriptor,
        new java.lang.String[] { "Op", "Cond", });
    internal_static_Mysqlx_Expect_Open_Condition_descriptor =
      internal_static_Mysqlx_Expect_Open_descriptor.getNestedTypes().get(0);
    internal_static_Mysqlx_Expect_Open_Condition_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expect_Open_Condition_descriptor,
        new java.lang.String[] { "ConditionKey", "ConditionValue", "Op", });
    internal_static_Mysqlx_Expect_Close_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Mysqlx_Expect_Close_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Expect_Close_descriptor,
        new java.lang.String[] { });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(com.mysql.cj.x.protobuf.Mysqlx.clientMessageId);
    registry.add(com.mysql.cj.x.protobuf.Mysqlx.clientMessageId);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    com.mysql.cj.x.protobuf.Mysqlx.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
