package net.sourceforge.lept4j;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;
/**
 * Data returned from correlation matching on a single character<br>
 * <i>native declaration : recog.h:128</i><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> , <a href="http://rococoa.dev.java.net/">Rococoa</a>, or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public class L_Rch extends Structure {
	/**
	 * index of best template<br>
	 * C type : l_int32
	 */
	public int index;
	/**
	 * correlation score of best template<br>
	 * C type : l_float32
	 */
	public float score;
	/**
	 * character string of best template<br>
	 * C type : char*
	 */
	public Pointer text;
	/**
	 * index of best sample (within the best<br>
	 * C type : l_int32
	 */
	public int sample;
	/**
	 * x-location of template (delx + shiftx)<br>
	 * C type : l_int32
	 */
	public int xloc;
	/**
	 * y-location of template (dely + shifty)<br>
	 * C type : l_int32
	 */
	public int yloc;
	/**
	 * width of best template<br>
	 * C type : l_int32
	 */
	public int width;
	public L_Rch() {
		super();
	}
	protected List<? > getFieldOrder() {
		return Arrays.asList("index", "score", "text", "sample", "xloc", "yloc", "width");
	}
	/**
	 * @param index index of best template<br>
	 * C type : l_int32<br>
	 * @param score correlation score of best template<br>
	 * C type : l_float32<br>
	 * @param text character string of best template<br>
	 * C type : char*<br>
	 * @param sample index of best sample (within the best<br>
	 * C type : l_int32<br>
	 * @param xloc x-location of template (delx + shiftx)<br>
	 * C type : l_int32<br>
	 * @param yloc y-location of template (dely + shifty)<br>
	 * C type : l_int32<br>
	 * @param width width of best template<br>
	 * C type : l_int32
	 */
	public L_Rch(int index, float score, Pointer text, int sample, int xloc, int yloc, int width) {
		super();
		this.index = index;
		this.score = score;
		this.text = text;
		this.sample = sample;
		this.xloc = xloc;
		this.yloc = yloc;
		this.width = width;
	}
	public L_Rch(Pointer peer) {
		super(peer);
		read();
	}
	public static class ByReference extends L_Rch implements Structure.ByReference {
		
	};
	public static class ByValue extends L_Rch implements Structure.ByValue {
		
	};
}
