/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lept4j.util;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.lept4j.Leptonica;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class LoadLibs {
    private static final String JNA_LIBRARY_PATH = "jna.library.path";
    public static final String LEPT4J_TEMP_DIR = new File(System.getProperty("java.io.tmpdir"), "lept4j").getPath();
    public static final String LIB_NAME = "liblept173";
    public static final String LIB_NAME_NON_WIN = "lept";
    private static final Logger logger = Logger.getLogger(LoadLibs.class.getName());

    public static Leptonica getLeptonicaInstance() {
        return (Leptonica)Native.loadLibrary((String)LoadLibs.getLeptonicaLibName(), Leptonica.class);
    }

    public static String getLeptonicaLibName() {
        return Platform.isWindows() ? LIB_NAME : LIB_NAME_NON_WIN;
    }

    public static File extractNativeResources(String dirname) {
        File targetTempDir = null;
        try {
            targetTempDir = new File(LEPT4J_TEMP_DIR, dirname);
            URL leptResourceUrl = LoadLibs.class.getResource(dirname.startsWith("/") ? dirname : "/" + dirname);
            if (leptResourceUrl == null) {
                return null;
            }
            URLConnection urlConnection = leptResourceUrl.openConnection();
            if (urlConnection instanceof JarURLConnection) {
                LoadLibs.copyJarResourceToDirectory((JarURLConnection)urlConnection, targetTempDir);
            } else {
                FileUtils.copyDirectory((File)new File(leptResourceUrl.getPath()), (File)targetTempDir);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return targetTempDir;
    }

    static void copyJarResourceToDirectory(JarURLConnection jarConnection, File destDir) {
        try {
            JarFile jarFile = jarConnection.getJarFile();
            String jarConnectionEntryName = jarConnection.getEntryName() + "/";
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry jarEntry = e.nextElement();
                String jarEntryName = jarEntry.getName();
                if (!jarEntryName.startsWith(jarConnectionEntryName)) continue;
                String filename = jarEntryName.substring(jarConnectionEntryName.length());
                File currentFile = new File(destDir, filename);
                if (jarEntry.isDirectory()) {
                    currentFile.mkdirs();
                    continue;
                }
                currentFile.deleteOnExit();
                InputStream is = jarFile.getInputStream(jarEntry);
                FileOutputStream out = FileUtils.openOutputStream((File)currentFile);
                IOUtils.copy((InputStream)is, (OutputStream)out);
                is.close();
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    static {
        System.setProperty("jna.encoding", "UTF8");
        File targetTempFolder = LoadLibs.extractNativeResources(Platform.RESOURCE_PREFIX);
        if (targetTempFolder != null && targetTempFolder.exists()) {
            String userCustomizedPath = System.getProperty(JNA_LIBRARY_PATH);
            if (null == userCustomizedPath || userCustomizedPath.isEmpty()) {
                System.setProperty(JNA_LIBRARY_PATH, targetTempFolder.getPath());
            } else {
                System.setProperty(JNA_LIBRARY_PATH, userCustomizedPath + File.pathSeparator + targetTempFolder.getPath());
            }
        }
    }
}

