/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.IOUtils;

class StoredFieldsConsumer {
    final DocumentsWriterPerThread docWriter;
    StoredFieldsWriter writer;
    int lastDoc;

    StoredFieldsConsumer(DocumentsWriterPerThread docWriter) {
        this.docWriter = docWriter;
        this.lastDoc = -1;
    }

    protected void initStoredFieldsWriter() throws IOException {
        if (this.writer == null) {
            this.writer = this.docWriter.codec.storedFieldsFormat().fieldsWriter(this.docWriter.directory, this.docWriter.getSegmentInfo(), IOContext.DEFAULT);
        }
    }

    void startDocument(int docID) throws IOException {
        assert (this.lastDoc < docID);
        this.initStoredFieldsWriter();
        while (++this.lastDoc < docID) {
            this.writer.startDocument();
            this.writer.finishDocument();
        }
        this.writer.startDocument();
    }

    void writeField(FieldInfo info, IndexableField field) throws IOException {
        this.writer.writeField(info, field);
    }

    void finishDocument() throws IOException {
        this.writer.finishDocument();
    }

    void finish(int maxDoc) throws IOException {
        while (this.lastDoc < maxDoc - 1) {
            this.startDocument(this.lastDoc);
            this.finishDocument();
            ++this.lastDoc;
        }
    }

    void flush(SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        try {
            this.writer.finish(state.fieldInfos, state.segmentInfo.maxDoc());
        }
        catch (Throwable throwable) {
            IOUtils.close(this.writer);
            this.writer = null;
            throw throwable;
        }
        IOUtils.close(this.writer);
        this.writer = null;
    }

    void abort() {
        if (this.writer != null) {
            IOUtils.closeWhileHandlingException(this.writer);
            this.writer = null;
        }
    }
}

