/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.List;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientBootstrap;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.client.TransportResponseHandler;
import org.apache.spark.network.protocol.MessageDecoder;
import org.apache.spark.network.protocol.MessageEncoder;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportChannelHandler;
import org.apache.spark.network.server.TransportRequestHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.util.NettyUtils;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.collect.Lists;

public class TransportContext {
    private static final Logger logger = LoggerFactory.getLogger(TransportContext.class);
    private final TransportConf conf;
    private final RpcHandler rpcHandler;
    private final boolean closeIdleConnections;
    private final MessageEncoder encoder;
    private final MessageDecoder decoder;

    public TransportContext(TransportConf conf, RpcHandler rpcHandler) {
        this(conf, rpcHandler, false);
    }

    public TransportContext(TransportConf conf, RpcHandler rpcHandler, boolean closeIdleConnections) {
        this.conf = conf;
        this.rpcHandler = rpcHandler;
        this.encoder = new MessageEncoder();
        this.decoder = new MessageDecoder();
        this.closeIdleConnections = closeIdleConnections;
    }

    public TransportClientFactory createClientFactory(List<TransportClientBootstrap> bootstraps) {
        return new TransportClientFactory(this, bootstraps);
    }

    public TransportClientFactory createClientFactory() {
        return this.createClientFactory(Lists.newArrayList());
    }

    public TransportServer createServer(int port, List<TransportServerBootstrap> bootstraps) {
        return new TransportServer(this, null, port, this.rpcHandler, bootstraps);
    }

    public TransportServer createServer(String host, int port, List<TransportServerBootstrap> bootstraps) {
        return new TransportServer(this, host, port, this.rpcHandler, bootstraps);
    }

    public TransportServer createServer(List<TransportServerBootstrap> bootstraps) {
        return this.createServer(0, bootstraps);
    }

    public TransportServer createServer() {
        return this.createServer(0, Lists.newArrayList());
    }

    public TransportChannelHandler initializePipeline(SocketChannel channel) {
        return this.initializePipeline(channel, this.rpcHandler);
    }

    public TransportChannelHandler initializePipeline(SocketChannel channel, RpcHandler channelRpcHandler) {
        try {
            TransportChannelHandler channelHandler = this.createChannelHandler((Channel)channel, channelRpcHandler);
            channel.pipeline().addLast("encoder", (ChannelHandler)this.encoder).addLast("frameDecoder", (ChannelHandler)NettyUtils.createFrameDecoder()).addLast("decoder", (ChannelHandler)this.decoder).addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, this.conf.connectionTimeoutMs() / 1000)).addLast("handler", (ChannelHandler)channelHandler);
            return channelHandler;
        }
        catch (RuntimeException e) {
            logger.error("Error while initializing Netty pipeline", (Throwable)e);
            throw e;
        }
    }

    private TransportChannelHandler createChannelHandler(Channel channel, RpcHandler rpcHandler) {
        TransportResponseHandler responseHandler = new TransportResponseHandler(channel);
        TransportClient client = new TransportClient(channel, responseHandler);
        TransportRequestHandler requestHandler = new TransportRequestHandler(channel, client, rpcHandler);
        return new TransportChannelHandler(client, responseHandler, requestHandler, this.conf.connectionTimeoutMs(), this.closeIdleConnections);
    }

    public TransportConf getConf() {
        return this.conf;
    }
}

