/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.params;

import java.math.BigInteger;
import org.bitcoinj.params.AbstractBitcoinNetParams;

public class UnitTestParams
extends AbstractBitcoinNetParams {
    public static final int UNITNET_MAJORITY_WINDOW = 8;
    public static final int TESTNET_MAJORITY_REJECT_BLOCK_OUTDATED = 6;
    public static final int TESTNET_MAJORITY_ENFORCE_BLOCK_UPGRADE = 4;
    private static UnitTestParams instance;

    public UnitTestParams() {
        this.id = "org.bitcoinj.unittest";
        this.packetMagic = 185665799L;
        this.addressHeader = 111;
        this.p2shHeader = 196;
        this.acceptableAddressCodes = new int[]{this.addressHeader, this.p2shHeader};
        this.maxTarget = new BigInteger("00ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff", 16);
        this.genesisBlock.setTime(System.currentTimeMillis() / 1000L);
        this.genesisBlock.setDifficultyTarget(545259519L);
        this.genesisBlock.solve();
        this.port = 18333;
        this.interval = 10;
        this.dumpedPrivateKeyHeader = 239;
        this.targetTimespan = 200000000;
        this.spendableCoinbaseDepth = 5;
        this.subsidyDecreaseBlockCount = 100;
        this.dnsSeeds = null;
        this.addrSeeds = null;
        this.bip32HeaderPub = 70617039;
        this.bip32HeaderPriv = 70615956;
        this.majorityEnforceBlockUpgrade = 3;
        this.majorityRejectBlockOutdated = 4;
        this.majorityWindow = 7;
    }

    public static synchronized UnitTestParams get() {
        if (instance == null) {
            instance = new UnitTestParams();
        }
        return instance;
    }

    @Override
    public String getPaymentProtocolId() {
        return "unittest";
    }
}

