/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid;

import com.subgraph.orchid.circuits.hs.HSDescriptorCookie;
import com.subgraph.orchid.config.TorConfigBridgeLine;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.data.IPv4Address;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.concurrent.TimeUnit;

public interface TorConfig {
    @ConfigVar(type=ConfigVarType.PATH, defaultValue="~/.orchid")
    public File getDataDirectory();

    public void setDataDirectory(File var1);

    @ConfigVar(type=ConfigVarType.INTERVAL, defaultValue="60 seconds")
    public long getCircuitBuildTimeout();

    public void setCircuitBuildTimeout(long var1, TimeUnit var3);

    @ConfigVar(type=ConfigVarType.INTERVAL, defaultValue="0")
    public long getCircuitStreamTimeout();

    public void setCircuitStreamTimeout(long var1, TimeUnit var3);

    @ConfigVar(type=ConfigVarType.INTERVAL, defaultValue="1 hour")
    public long getCircuitIdleTimeout();

    public void setCircuitIdleTimeout(long var1, TimeUnit var3);

    @ConfigVar(type=ConfigVarType.INTERVAL, defaultValue="30 seconds")
    public long getNewCircuitPeriod();

    public void setNewCircuitPeriod(long var1, TimeUnit var3);

    @ConfigVar(type=ConfigVarType.INTERVAL, defaultValue="10 minutes")
    public long getMaxCircuitDirtiness();

    public void setMaxCircuitDirtiness(long var1, TimeUnit var3);

    @ConfigVar(type=ConfigVarType.INTEGER, defaultValue="32")
    public int getMaxClientCircuitsPending();

    public void setMaxClientCircuitsPending(int var1);

    @ConfigVar(type=ConfigVarType.BOOLEAN, defaultValue="true")
    public boolean getEnforceDistinctSubnets();

    public void setEnforceDistinctSubnets(boolean var1);

    @ConfigVar(type=ConfigVarType.INTERVAL, defaultValue="2 minutes")
    public long getSocksTimeout();

    public void setSocksTimeout(long var1);

    @ConfigVar(type=ConfigVarType.INTEGER, defaultValue="3")
    public int getNumEntryGuards();

    public void setNumEntryGuards(int var1);

    @ConfigVar(type=ConfigVarType.BOOLEAN, defaultValue="true")
    public boolean getUseEntryGuards();

    public void setUseEntryGuards(boolean var1);

    @ConfigVar(type=ConfigVarType.PORTLIST, defaultValue="21,22,706,1863,5050,5190,5222,5223,6523,6667,6697,8300")
    public List<Integer> getLongLivedPorts();

    public void setLongLivedPorts(List<Integer> var1);

    @ConfigVar(type=ConfigVarType.STRINGLIST)
    public List<String> getExcludeNodes();

    public void setExcludeNodes(List<String> var1);

    @ConfigVar(type=ConfigVarType.STRINGLIST)
    public List<String> getExcludeExitNodes();

    public void setExcludeExitNodes(List<String> var1);

    @ConfigVar(type=ConfigVarType.STRINGLIST)
    public List<String> getExitNodes();

    public void setExitNodes(List<String> var1);

    @ConfigVar(type=ConfigVarType.STRINGLIST)
    public List<String> getEntryNodes();

    public void setEntryNodes(List<String> var1);

    @ConfigVar(type=ConfigVarType.BOOLEAN, defaultValue="false")
    public boolean getStrictNodes();

    public void setStrictNodes(boolean var1);

    @ConfigVar(type=ConfigVarType.BOOLEAN, defaultValue="false")
    public boolean getFascistFirewall();

    public void setFascistFirewall(boolean var1);

    @ConfigVar(type=ConfigVarType.PORTLIST, defaultValue="80,443")
    public List<Integer> getFirewallPorts();

    public void setFirewallPorts(List<Integer> var1);

    @ConfigVar(type=ConfigVarType.BOOLEAN, defaultValue="false")
    public boolean getSafeSocks();

    public void setSafeSocks(boolean var1);

    @ConfigVar(type=ConfigVarType.BOOLEAN, defaultValue="true")
    public boolean getSafeLogging();

    public void setSafeLogging(boolean var1);

    @ConfigVar(type=ConfigVarType.BOOLEAN, defaultValue="true")
    public boolean getWarnUnsafeSocks();

    public void setWarnUnsafeSocks(boolean var1);

    @ConfigVar(type=ConfigVarType.BOOLEAN, defaultValue="true")
    public boolean getClientRejectInternalAddress();

    public void setClientRejectInternalAddress(boolean var1);

    @ConfigVar(type=ConfigVarType.BOOLEAN, defaultValue="true")
    public boolean getHandshakeV3Enabled();

    public void setHandshakeV3Enabled(boolean var1);

    @ConfigVar(type=ConfigVarType.BOOLEAN, defaultValue="true")
    public boolean getHandshakeV2Enabled();

    public void setHandshakeV2Enabled(boolean var1);

    @ConfigVar(type=ConfigVarType.HS_AUTH)
    public HSDescriptorCookie getHidServAuth(String var1);

    public void addHidServAuth(String var1, String var2);

    @ConfigVar(type=ConfigVarType.AUTOBOOL, defaultValue="auto")
    public AutoBoolValue getUseNTorHandshake();

    public void setUseNTorHandshake(AutoBoolValue var1);

    @ConfigVar(type=ConfigVarType.AUTOBOOL, defaultValue="auto")
    public AutoBoolValue getUseMicrodescriptors();

    public void setUseMicrodescriptors(AutoBoolValue var1);

    @ConfigVar(type=ConfigVarType.BOOLEAN, defaultValue="false")
    public boolean getUseBridges();

    public void setUseBridges(boolean var1);

    @ConfigVar(type=ConfigVarType.BRIDGE_LINE)
    public List<TorConfigBridgeLine> getBridges();

    public void addBridge(IPv4Address var1, int var2);

    public void addBridge(IPv4Address var1, int var2, HexDigest var3);

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ConfigVar {
        public ConfigVarType type();

        public String defaultValue() default "";
    }

    public static enum AutoBoolValue {
        TRUE,
        FALSE,
        AUTO;

    }

    public static enum ConfigVarType {
        INTEGER,
        STRING,
        HS_AUTH,
        BOOLEAN,
        INTERVAL,
        PORTLIST,
        STRINGLIST,
        PATH,
        AUTOBOOL,
        BRIDGE_LINE;

    }
}

