/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.Circuit;
import com.subgraph.orchid.CircuitBuildHandler;
import com.subgraph.orchid.CircuitNode;
import com.subgraph.orchid.Connection;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.circuits.CircuitImpl;
import com.subgraph.orchid.circuits.path.CircuitPathChooser;
import com.subgraph.orchid.circuits.path.PathSelectionFailedException;
import java.util.Collections;
import java.util.List;

public class CircuitCreationRequest
implements CircuitBuildHandler {
    private final CircuitImpl circuit;
    private final CircuitPathChooser pathChooser;
    private final CircuitBuildHandler buildHandler;
    private final boolean isDirectoryCircuit;
    private List<Router> path;

    public CircuitCreationRequest(CircuitPathChooser pathChooser, Circuit circuit, CircuitBuildHandler buildHandler, boolean isDirectoryCircuit) {
        this.pathChooser = pathChooser;
        this.circuit = (CircuitImpl)circuit;
        this.buildHandler = buildHandler;
        this.path = Collections.emptyList();
        this.isDirectoryCircuit = isDirectoryCircuit;
    }

    void choosePath() throws InterruptedException, PathSelectionFailedException {
        if (!(this.circuit instanceof CircuitImpl)) {
            throw new IllegalArgumentException();
        }
        this.path = this.circuit.choosePath(this.pathChooser);
    }

    CircuitImpl getCircuit() {
        return this.circuit;
    }

    List<Router> getPath() {
        return this.path;
    }

    int getPathLength() {
        return this.path.size();
    }

    Router getPathElement(int idx) {
        return this.path.get(idx);
    }

    CircuitBuildHandler getBuildHandler() {
        return this.buildHandler;
    }

    boolean isDirectoryCircuit() {
        return this.isDirectoryCircuit;
    }

    @Override
    public void connectionCompleted(Connection connection) {
        if (this.buildHandler != null) {
            this.buildHandler.connectionCompleted(connection);
        }
    }

    @Override
    public void connectionFailed(String reason) {
        if (this.buildHandler != null) {
            this.buildHandler.connectionFailed(reason);
        }
    }

    @Override
    public void nodeAdded(CircuitNode node) {
        if (this.buildHandler != null) {
            this.buildHandler.nodeAdded(node);
        }
    }

    @Override
    public void circuitBuildCompleted(Circuit circuit) {
        if (this.buildHandler != null) {
            this.buildHandler.circuitBuildCompleted(circuit);
        }
    }

    @Override
    public void circuitBuildFailed(String reason) {
        if (this.buildHandler != null) {
            this.buildHandler.circuitBuildFailed(reason);
        }
    }
}

