/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.circuits.PredictedPortTarget;
import com.subgraph.orchid.dashboard.DashboardRenderable;
import com.subgraph.orchid.dashboard.DashboardRenderer;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class CircuitPredictor
implements DashboardRenderable {
    private static final Integer INTERNAL_CIRCUIT_PORT_VALUE = 0;
    private static final long TIMEOUT_MS = 3600000L;
    private final Map<Integer, Long> portsSeen = new HashMap<Integer, Long>();

    public CircuitPredictor() {
        this.addExitPortRequest(80);
        this.addInternalRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addExitPortRequest(int port) {
        Map<Integer, Long> map = this.portsSeen;
        synchronized (map) {
            this.portsSeen.put(port, System.currentTimeMillis());
        }
    }

    void addInternalRequest() {
        this.addExitPortRequest(INTERNAL_CIRCUIT_PORT_VALUE);
    }

    private boolean isEntryExpired(Map.Entry<Integer, Long> e, long now) {
        return now - e.getValue() > 3600000L;
    }

    private void removeExpiredPorts() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<Integer, Long>> it = this.portsSeen.entrySet().iterator();
        while (it.hasNext()) {
            if (!this.isEntryExpired(it.next(), now)) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInternalPredicted() {
        Map<Integer, Long> map = this.portsSeen;
        synchronized (map) {
            this.removeExpiredPorts();
            return this.portsSeen.containsKey(INTERNAL_CIRCUIT_PORT_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Integer> getPredictedPorts() {
        Map<Integer, Long> map = this.portsSeen;
        synchronized (map) {
            this.removeExpiredPorts();
            HashSet<Integer> result = new HashSet<Integer>(this.portsSeen.keySet());
            result.remove(INTERNAL_CIRCUIT_PORT_VALUE);
            return result;
        }
    }

    List<PredictedPortTarget> getPredictedPortTargets() {
        ArrayList<PredictedPortTarget> targets = new ArrayList<PredictedPortTarget>();
        for (int p : this.getPredictedPorts()) {
            targets.add(new PredictedPortTarget(p));
        }
        return targets;
    }

    @Override
    public void dashboardRender(DashboardRenderer renderer, PrintWriter writer, int flags) throws IOException {
        if ((flags & 4) == 0) {
            return;
        }
        writer.println("[Predicted Ports] ");
        for (int port : this.portsSeen.keySet()) {
            writer.write(" " + port);
            Long lastSeen = this.portsSeen.get(port);
            if (lastSeen != null) {
                long now = System.currentTimeMillis();
                long ms = now - lastSeen;
                writer.write(" (last seen " + TimeUnit.MINUTES.convert(ms, TimeUnit.MILLISECONDS) + " minutes ago)");
            }
            writer.println();
        }
        writer.println();
    }
}

