/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.RelayCell;
import com.subgraph.orchid.Stream;
import com.subgraph.orchid.circuits.cells.RelayCellImpl;
import com.subgraph.orchid.misc.GuardedBy;
import com.subgraph.orchid.misc.ThreadSafe;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;

@ThreadSafe
public class TorInputStream
extends InputStream {
    private static final RelayCell CLOSE_SENTINEL = new RelayCellImpl(null, 0, 0, 0);
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final Stream stream;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final Queue<RelayCell> incomingCells;
    @GuardedBy(value="lock")
    private int availableBytes;
    @GuardedBy(value="lock")
    private long bytesReceived;
    @GuardedBy(value="lock")
    private ByteBuffer currentBuffer;
    @GuardedBy(value="lock")
    private boolean isEOF;
    @GuardedBy(value="lock")
    private boolean isClosed;

    TorInputStream(Stream stream) {
        this.stream = stream;
        this.incomingCells = new LinkedList<RelayCell>();
        this.currentBuffer = EMPTY_BUFFER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getBytesReceived() {
        Object object = this.lock;
        synchronized (object) {
            return this.bytesReceived;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException("Stream closed");
            }
            this.refillBufferIfNeeded();
            if (this.isEOF) {
                return -1;
            }
            --this.availableBytes;
            return this.currentBuffer.get() & 0xFF;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException("Stream closed");
            }
            this.checkReadArguments(b, off, len);
            if (len == 0) {
                return 0;
            }
            this.refillBufferIfNeeded();
            if (this.isEOF) {
                return -1;
            }
            int bytesRead = 0;
            int bytesRemaining = len;
            while (bytesRemaining > 0 && !this.isEOF) {
                this.refillBufferIfNeeded();
                bytesRead += this.readFromCurrentBuffer(b, off + bytesRead, len - bytesRead);
                bytesRemaining = len - bytesRead;
                if (this.availableBytes != 0) continue;
                return bytesRead;
            }
            return bytesRead;
        }
    }

    @GuardedBy(value="lock")
    private int readFromCurrentBuffer(byte[] b, int off, int len) {
        int readLength = this.currentBuffer.remaining() >= len ? len : this.currentBuffer.remaining();
        this.currentBuffer.get(b, off, readLength);
        this.availableBytes -= readLength;
        return readLength;
    }

    private void checkReadArguments(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off >= b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() {
        Object object = this.lock;
        synchronized (object) {
            return this.availableBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.incomingCells.add(CLOSE_SENTINEL);
            this.lock.notifyAll();
        }
        this.stream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEndCell(RelayCell cell) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.incomingCells.add(cell);
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInputCell(RelayCell cell) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.incomingCells.add(cell);
            this.bytesReceived += (long)cell.cellBytesRemaining();
            this.availableBytes += cell.cellBytesRemaining();
            this.lock.notifyAll();
        }
    }

    @GuardedBy(value="lock")
    private void refillBufferIfNeeded() throws IOException {
        if (!this.isEOF) {
            if (this.currentBuffer.hasRemaining()) {
                return;
            }
            this.fillBuffer();
        }
    }

    @GuardedBy(value="lock")
    private void fillBuffer() throws IOException {
        do {
            this.processIncomingCell(this.getNextCell());
        } while (!this.isEOF && !this.currentBuffer.hasRemaining());
    }

    @GuardedBy(value="lock")
    private void processIncomingCell(RelayCell nextCell) throws IOException {
        if (this.isClosed || nextCell == CLOSE_SENTINEL) {
            throw new IOException("Input stream closed");
        }
        switch (nextCell.getRelayCommand()) {
            case 2: {
                this.currentBuffer = nextCell.getPayloadBuffer();
                break;
            }
            case 3: {
                this.currentBuffer = EMPTY_BUFFER;
                this.isEOF = true;
                break;
            }
            default: {
                throw new IOException("Unexpected RelayCell command type in TorInputStream queue: " + nextCell.getRelayCommand());
            }
        }
    }

    @GuardedBy(value="lock")
    private RelayCell getNextCell() throws IOException {
        try {
            while (this.incomingCells.isEmpty()) {
                this.lock.wait();
            }
            return this.incomingCells.remove();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Read interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int unflushedCellCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.incomingCells.size();
        }
    }

    public String toString() {
        return "TorInputStream stream=" + this.stream.getStreamId() + " node=" + this.stream.getTargetNode();
    }
}

