/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.hs;

import com.subgraph.orchid.TorParsingException;
import com.subgraph.orchid.circuits.hs.IntroductionPoint;
import com.subgraph.orchid.circuits.hs.IntroductionPointKeyword;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.directory.parsing.BasicDocumentParsingResult;
import com.subgraph.orchid.directory.parsing.DocumentFieldParser;
import com.subgraph.orchid.directory.parsing.DocumentParser;
import com.subgraph.orchid.directory.parsing.DocumentParsingHandler;
import com.subgraph.orchid.directory.parsing.DocumentParsingResult;
import com.subgraph.orchid.directory.parsing.DocumentParsingResultHandler;

public class IntroductionPointParser
implements DocumentParser<IntroductionPoint> {
    private final DocumentFieldParser fieldParser;
    private DocumentParsingResultHandler<IntroductionPoint> resultHandler;
    private IntroductionPoint currentIntroductionPoint;

    public IntroductionPointParser(DocumentFieldParser fieldParser) {
        this.fieldParser = fieldParser;
        this.fieldParser.setHandler(this.createParsingHandler());
    }

    @Override
    public boolean parse(DocumentParsingResultHandler<IntroductionPoint> resultHandler) {
        this.resultHandler = resultHandler;
        try {
            this.fieldParser.processDocument();
            return true;
        }
        catch (TorParsingException e) {
            resultHandler.parsingError(e.getMessage());
            return false;
        }
    }

    @Override
    public DocumentParsingResult<IntroductionPoint> parse() {
        BasicDocumentParsingResult<IntroductionPoint> result = new BasicDocumentParsingResult<IntroductionPoint>();
        this.parse((DocumentParsingResultHandler<IntroductionPoint>)result);
        return result;
    }

    private DocumentParsingHandler createParsingHandler() {
        return new DocumentParsingHandler(){

            @Override
            public void parseKeywordLine() {
                IntroductionPointParser.this.processKeywordLine();
            }

            @Override
            public void endOfDocument() {
                IntroductionPointParser.this.validateAndReportIntroductionPoint(IntroductionPointParser.this.currentIntroductionPoint);
            }
        };
    }

    private void resetIntroductionPoint(HexDigest identity) {
        this.validateAndReportIntroductionPoint(this.currentIntroductionPoint);
        this.currentIntroductionPoint = new IntroductionPoint(identity);
    }

    private void validateAndReportIntroductionPoint(IntroductionPoint introductionPoint) {
        if (introductionPoint == null) {
            return;
        }
        if (introductionPoint.isValidDocument()) {
            this.resultHandler.documentParsed(introductionPoint);
        } else {
            this.resultHandler.documentInvalid(introductionPoint, "Invalid introduction point");
        }
    }

    private void processKeywordLine() {
        IntroductionPointKeyword keyword = IntroductionPointKeyword.findKeyword(this.fieldParser.getCurrentKeyword());
        if (!keyword.equals((Object)IntroductionPointKeyword.UNKNOWN_KEYWORD)) {
            this.processKeyword(keyword);
        }
    }

    private void processKeyword(IntroductionPointKeyword keyword) {
        switch (keyword) {
            case INTRO_AUTHENTICATION: {
                break;
            }
            case INTRODUCTION_POINT: {
                this.resetIntroductionPoint(this.fieldParser.parseBase32Digest());
                break;
            }
            case IP_ADDRESS: {
                if (this.currentIntroductionPoint == null) break;
                this.currentIntroductionPoint.setAddress(this.fieldParser.parseAddress());
                break;
            }
            case ONION_KEY: {
                if (this.currentIntroductionPoint == null) break;
                this.currentIntroductionPoint.setOnionKey(this.fieldParser.parsePublicKey());
                break;
            }
            case ONION_PORT: {
                if (this.currentIntroductionPoint == null) break;
                this.currentIntroductionPoint.setOnionPort(this.fieldParser.parsePort());
                break;
            }
            case SERVICE_KEY: {
                if (this.currentIntroductionPoint == null) break;
                this.currentIntroductionPoint.setServiceKey(this.fieldParser.parsePublicKey());
                break;
            }
            case SERVICE_AUTHENTICATION: {
                break;
            }
        }
    }
}

