/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.hs;

import com.subgraph.orchid.Cell;
import com.subgraph.orchid.HiddenServiceCircuit;
import com.subgraph.orchid.InternalCircuit;
import com.subgraph.orchid.RelayCell;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.circuits.CircuitNodeImpl;
import com.subgraph.orchid.crypto.TorRandom;
import com.subgraph.orchid.crypto.TorTapKeyAgreement;
import com.subgraph.orchid.data.HexDigest;
import java.math.BigInteger;
import java.util.logging.Logger;

public class RendezvousProcessor {
    private static final Logger logger = Logger.getLogger(RendezvousProcessor.class.getName());
    private static final int RENDEZVOUS_COOKIE_LEN = 20;
    private static final TorRandom random = new TorRandom();
    private final InternalCircuit circuit;
    private final byte[] cookie;

    protected RendezvousProcessor(InternalCircuit circuit) {
        this.circuit = circuit;
        this.cookie = random.getBytes(20);
    }

    boolean establishRendezvous() {
        RelayCell cell = this.circuit.createRelayCell(33, 0, this.circuit.getFinalCircuitNode());
        cell.putByteArray(this.cookie);
        this.circuit.sendRelayCell(cell);
        RelayCell response = this.circuit.receiveRelayCell();
        if (response == null) {
            logger.info("Timeout waiting for Rendezvous establish response");
            return false;
        }
        if (response.getRelayCommand() != 39) {
            logger.info("Response received from Rendezvous establish was not expected acknowledgement, Relay Command: " + response.getRelayCommand());
            return false;
        }
        return true;
    }

    HiddenServiceCircuit processRendezvous2(TorTapKeyAgreement kex) {
        RelayCell cell = this.circuit.receiveRelayCell();
        if (cell == null) {
            logger.info("Timeout waiting for RENDEZVOUS2");
            return null;
        }
        if (cell.getRelayCommand() != 37) {
            logger.info("Unexpected Relay cell type received while waiting for RENDEZVOUS2: " + cell.getRelayCommand());
            return null;
        }
        BigInteger peerPublic = this.readPeerPublic(cell);
        HexDigest handshakeDigest = this.readHandshakeDigest(cell);
        if (peerPublic == null || handshakeDigest == null) {
            return null;
        }
        byte[] verifyHash = new byte[20];
        byte[] keyMaterial = new byte[72];
        if (!kex.deriveKeysFromDHPublicAndHash(peerPublic, handshakeDigest.getRawBytes(), keyMaterial, verifyHash)) {
            logger.info("Error deriving session keys while extending to hidden service");
            return null;
        }
        return this.circuit.connectHiddenService(CircuitNodeImpl.createAnonymous(this.circuit.getFinalCircuitNode(), keyMaterial, verifyHash));
    }

    private BigInteger readPeerPublic(Cell cell) {
        byte[] dhPublic = new byte[128];
        cell.getByteArray(dhPublic);
        BigInteger peerPublic = new BigInteger(1, dhPublic);
        if (!TorTapKeyAgreement.isValidPublicValue(peerPublic)) {
            logger.warning("Illegal DH public value received: " + peerPublic);
            return null;
        }
        return peerPublic;
    }

    HexDigest readHandshakeDigest(Cell cell) {
        byte[] digestBytes = new byte[20];
        cell.getByteArray(digestBytes);
        return HexDigest.createFromDigestBytes(digestBytes);
    }

    byte[] getCookie() {
        return this.cookie;
    }

    Router getRendezvousRouter() {
        return this.circuit.getFinalCircuitNode().getRouter();
    }
}

