/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.path;

import com.subgraph.orchid.Router;
import com.subgraph.orchid.circuits.path.RouterFilter;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.data.IPv4Address;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigNodeFilter
implements RouterFilter {
    private static final Pattern NETMASK_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)/(\\d+)$");
    private static final Pattern ADDRESS_BITS_PATTERN = Pattern.compile("^(\\d+\\.\\d+\\.\\d+\\.\\d+)/(\\d+)$");
    private static final Pattern IDENTITY_PATTERN = Pattern.compile("^[A-Fa-f0-9]{40}$");
    private static final Pattern COUNTRYCODE_PATTERN = Pattern.compile("^\\{([A-Za-z]{2})\\}$");
    private static final Pattern ROUTERNAME_PATTERN = Pattern.compile("^\\w{1,19}$");
    private final List<RouterFilter> filterList;

    static boolean isAddressString(String s) {
        Matcher matcher = NETMASK_PATTERN.matcher(s);
        if (!matcher.matches()) {
            return false;
        }
        try {
            for (int i = 1; i < 5; ++i) {
                if (ConfigNodeFilter.isValidOctetString(matcher.group(i))) continue;
                return false;
            }
            return ConfigNodeFilter.isValidMaskValue(matcher.group(5));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isValidOctetString(String s) {
        int n = Integer.parseInt(s);
        return n >= 0 && n <= 255;
    }

    private static boolean isValidMaskValue(String s) {
        int n = Integer.parseInt(s);
        return n > 0 && n <= 32;
    }

    static boolean isIdentityString(String s) {
        return IDENTITY_PATTERN.matcher(s).matches();
    }

    static boolean isCountryCodeString(String s) {
        return COUNTRYCODE_PATTERN.matcher(s).matches();
    }

    static boolean isNameString(String s) {
        return ROUTERNAME_PATTERN.matcher(s).matches();
    }

    static RouterFilter createFilterFor(String s) {
        if (ConfigNodeFilter.isAddressString(s)) {
            return ConfigNodeFilter.createAddressFilter(s);
        }
        if (ConfigNodeFilter.isCountryCodeString(s)) {
            return ConfigNodeFilter.createCountryCodeFilter(s);
        }
        if (ConfigNodeFilter.isIdentityString(s)) {
            return ConfigNodeFilter.createIdentityFilter(s);
        }
        if (ConfigNodeFilter.isNameString(s)) {
            return ConfigNodeFilter.createNameFilter(s);
        }
        return null;
    }

    private static RouterFilter createAddressFilter(String s) {
        Matcher matcher = ADDRESS_BITS_PATTERN.matcher(s);
        if (!matcher.matches()) {
            throw new IllegalArgumentException();
        }
        IPv4Address network = IPv4Address.createFromString(matcher.group(1));
        int bits = Integer.parseInt(matcher.group(2));
        return new MaskFilter(network, bits);
    }

    private static RouterFilter createIdentityFilter(String s) {
        if (ConfigNodeFilter.isIdentityString(s)) {
            throw new IllegalArgumentException();
        }
        HexDigest identity = HexDigest.createFromString(s);
        return new IdentityFilter(identity);
    }

    private static RouterFilter createCountryCodeFilter(String s) {
        Matcher matcher = COUNTRYCODE_PATTERN.matcher(s);
        if (!matcher.matches()) {
            throw new IllegalArgumentException();
        }
        return new CountryCodeFilter(matcher.group(1));
    }

    private static RouterFilter createNameFilter(String s) {
        if (!ConfigNodeFilter.isNameString(s)) {
            throw new IllegalArgumentException();
        }
        return new NameFilter(s);
    }

    static ConfigNodeFilter createFromStrings(List<String> stringList) {
        ArrayList<RouterFilter> filters = new ArrayList<RouterFilter>();
        for (String s : stringList) {
            RouterFilter f = ConfigNodeFilter.createFilterFor(s);
            if (f == null) continue;
            filters.add(f);
        }
        return new ConfigNodeFilter(filters);
    }

    private ConfigNodeFilter(List<RouterFilter> filterList) {
        this.filterList = filterList;
    }

    @Override
    public boolean filter(Router router) {
        for (RouterFilter f : this.filterList) {
            if (!f.filter(router)) continue;
            return true;
        }
        return false;
    }

    boolean isEmpty() {
        return this.filterList.isEmpty();
    }

    static class CountryCodeFilter
    implements RouterFilter {
        private final String countryCode;

        public CountryCodeFilter(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public boolean filter(Router router) {
            return this.countryCode.equalsIgnoreCase(router.getCountryCode());
        }
    }

    static class NameFilter
    implements RouterFilter {
        private final String name;

        NameFilter(String name) {
            this.name = name;
        }

        @Override
        public boolean filter(Router router) {
            return this.name.equals(router.getNickname());
        }
    }

    static class IdentityFilter
    implements RouterFilter {
        private final HexDigest identity;

        IdentityFilter(HexDigest identity) {
            this.identity = identity;
        }

        @Override
        public boolean filter(Router router) {
            return router.getIdentityHash().equals(this.identity);
        }
    }

    static class MaskFilter
    implements RouterFilter {
        private final int network;
        private final int bits;
        private final int mask;

        static int createMask(int maskBitCount) {
            return maskBitCount == 0 ? 0 : Integer.MIN_VALUE >> maskBitCount - 1;
        }

        MaskFilter(IPv4Address network, int bits) {
            this.bits = bits;
            this.mask = MaskFilter.createMask(bits);
            this.network = network.getAddressData() & this.mask;
        }

        @Override
        public boolean filter(Router router) {
            int routerAddress = router.getAddress().getAddressData();
            return (routerAddress & this.mask) == this.network;
        }

        public String toString() {
            IPv4Address a = new IPv4Address(this.network);
            return a.toString() + "/" + this.bits;
        }
    }
}

