/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.connections;

import com.subgraph.orchid.Connection;
import com.subgraph.orchid.ConnectionCache;
import com.subgraph.orchid.ConnectionFailedException;
import com.subgraph.orchid.ConnectionHandshakeException;
import com.subgraph.orchid.ConnectionTimeoutException;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.circuits.TorInitializationTracker;
import com.subgraph.orchid.connections.ConnectionImpl;
import com.subgraph.orchid.connections.ConnectionSocketFactory;
import com.subgraph.orchid.dashboard.DashboardRenderable;
import com.subgraph.orchid.dashboard.DashboardRenderer;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocket;

public class ConnectionCacheImpl
implements ConnectionCache,
DashboardRenderable {
    private static final Logger logger = Logger.getLogger(ConnectionCacheImpl.class.getName());
    private final ConcurrentMap<Router, Future<ConnectionImpl>> activeConnections = new ConcurrentHashMap<Router, Future<ConnectionImpl>>();
    private final ConnectionSocketFactory factory = new ConnectionSocketFactory();
    private final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    private final TorConfig config;
    private final TorInitializationTracker initializationTracker;
    private volatile boolean isClosed;

    public ConnectionCacheImpl(TorConfig config, TorInitializationTracker tracker) {
        this.config = config;
        this.initializationTracker = tracker;
        this.scheduledExecutor.scheduleAtFixedRate(new CloseIdleConnectionCheckTask(), 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        for (Future f : this.activeConnections.values()) {
            if (f.isDone()) {
                try {
                    ConnectionImpl conn = (ConnectionImpl)f.get();
                    conn.closeSocket();
                }
                catch (InterruptedException e) {
                    logger.warning("Unexpected interruption while closing connection");
                }
                catch (ExecutionException e) {
                    logger.warning("Exception closing connection: " + e.getCause());
                }
                continue;
            }
            f.cancel(true);
        }
        this.activeConnections.clear();
        this.scheduledExecutor.shutdownNow();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public Connection getConnectionTo(Router router, boolean isDirectoryConnection) throws InterruptedException, ConnectionTimeoutException, ConnectionFailedException, ConnectionHandshakeException {
        if (this.isClosed) {
            throw new IllegalStateException("ConnectionCache has been closed");
        }
        logger.fine("Get connection to " + router.getAddress() + " " + router.getOnionPort() + " " + router.getNickname());
        while (true) {
            Future<ConnectionImpl> f = this.getFutureFor(router, isDirectoryConnection);
            try {
                Connection c = f.get();
                if (c.isClosed()) {
                    this.activeConnections.remove(router, f);
                    continue;
                }
                return c;
            }
            catch (CancellationException e) {
                this.activeConnections.remove(router, f);
                continue;
            }
            catch (ExecutionException e) {
                this.activeConnections.remove(router, f);
                Throwable t = e.getCause();
                if (t instanceof ConnectionTimeoutException) {
                    throw (ConnectionTimeoutException)t;
                }
                if (t instanceof ConnectionFailedException) {
                    throw (ConnectionFailedException)t;
                }
                if (t instanceof ConnectionHandshakeException) {
                    throw (ConnectionHandshakeException)t;
                }
                throw new RuntimeException("Unexpected exception: " + e, e);
            }
            break;
        }
    }

    private Future<ConnectionImpl> getFutureFor(Router router, boolean isDirectoryConnection) {
        Future f = (Future)this.activeConnections.get(router);
        if (f != null) {
            return f;
        }
        return this.createFutureForIfAbsent(router, isDirectoryConnection);
    }

    private Future<ConnectionImpl> createFutureForIfAbsent(Router router, boolean isDirectoryConnection) {
        ConnectionTask task = new ConnectionTask(router, isDirectoryConnection);
        FutureTask<ConnectionImpl> futureTask = new FutureTask<ConnectionImpl>(task);
        Future f = this.activeConnections.putIfAbsent(router, futureTask);
        if (f != null) {
            return f;
        }
        futureTask.run();
        return futureTask;
    }

    @Override
    public void dashboardRender(DashboardRenderer renderer, PrintWriter writer, int flags) throws IOException {
        if ((flags & 1) == 0) {
            return;
        }
        this.printDashboardBanner(writer, flags);
        for (Connection c : this.getActiveConnections()) {
            if (c.isClosed()) continue;
            renderer.renderComponent(writer, flags, c);
        }
        writer.println();
    }

    private void printDashboardBanner(PrintWriter writer, int flags) {
        boolean verbose;
        boolean bl = verbose = (flags & 2) != 0;
        if (verbose) {
            writer.println("[Connection Cache (verbose)]");
        } else {
            writer.println("[Connection Cache]");
        }
        writer.println();
    }

    List<Connection> getActiveConnections() {
        ArrayList<Connection> cs = new ArrayList<Connection>();
        for (Future future : this.activeConnections.values()) {
            this.addConnectionFromFuture(future, cs);
        }
        return cs;
    }

    private void addConnectionFromFuture(Future<ConnectionImpl> future, List<Connection> connectionList) {
        try {
            if (future.isDone() && !future.isCancelled()) {
                connectionList.add(future.get());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    private class CloseIdleConnectionCheckTask
    implements Runnable {
        private CloseIdleConnectionCheckTask() {
        }

        @Override
        public void run() {
            for (Future f : ConnectionCacheImpl.this.activeConnections.values()) {
                if (!f.isDone()) continue;
                try {
                    ConnectionImpl c = (ConnectionImpl)f.get();
                    c.idleCloseCheck();
                }
                catch (Exception exception) {}
            }
        }
    }

    private class ConnectionTask
    implements Callable<ConnectionImpl> {
        private final Router router;
        private final boolean isDirectoryConnection;

        ConnectionTask(Router router, boolean isDirectoryConnection) {
            this.router = router;
            this.isDirectoryConnection = isDirectoryConnection;
        }

        @Override
        public ConnectionImpl call() throws Exception {
            SSLSocket socket = ConnectionCacheImpl.this.factory.createSocket();
            ConnectionImpl conn = new ConnectionImpl(ConnectionCacheImpl.this.config, socket, this.router, ConnectionCacheImpl.this.initializationTracker, this.isDirectoryConnection);
            conn.connect();
            return conn;
        }
    }
}

