/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.connections;

import com.subgraph.orchid.ConnectionHandshakeException;
import com.subgraph.orchid.ConnectionIOException;
import com.subgraph.orchid.connections.ConnectionHandshake;
import com.subgraph.orchid.connections.ConnectionImpl;
import com.subgraph.orchid.connections.ConnectionSocketFactory;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

public class ConnectionHandshakeV2
extends ConnectionHandshake {
    ConnectionHandshakeV2(ConnectionImpl connection, SSLSocket socket) {
        super(connection, socket);
    }

    @Override
    void runHandshake() throws IOException, InterruptedException, ConnectionIOException {
        this.socket.setEnabledCipherSuites(ConnectionSocketFactory.V1_CIPHERS_ONLY);
        HandshakeFinishedMonitor monitor = new HandshakeFinishedMonitor();
        this.socket.addHandshakeCompletedListener(monitor);
        this.socket.startHandshake();
        monitor.waitFinished();
        this.socket.removeHandshakeCompletedListener(monitor);
        this.verifyIdentityKey(this.getIdentityKey());
        this.sendVersions(2);
        this.receiveVersions();
        this.sendNetinfo();
        this.recvNetinfo();
    }

    private PublicKey getIdentityKey() throws ConnectionHandshakeException {
        X509Certificate identityCertificate = this.getIdentityCertificateFromSession(this.socket.getSession());
        return identityCertificate.getPublicKey();
    }

    private X509Certificate getIdentityCertificateFromSession(SSLSession session) throws ConnectionHandshakeException {
        try {
            X509Certificate[] chain = session.getPeerCertificateChain();
            if (chain.length != 2) {
                throw new ConnectionHandshakeException("Expecting 2 certificate chain from router and received chain length " + chain.length);
            }
            chain[0].verify(chain[1].getPublicKey());
            return chain[1];
        }
        catch (SSLPeerUnverifiedException e) {
            throw new ConnectionHandshakeException("No certificates received from router");
        }
        catch (GeneralSecurityException e) {
            throw new ConnectionHandshakeException("Incorrect signature on certificate chain");
        }
        catch (CertificateException e) {
            throw new ConnectionHandshakeException("Malformed certificate received");
        }
    }

    private static class HandshakeFinishedMonitor
    implements HandshakeCompletedListener {
        final Object lock = new Object();
        boolean isFinished;

        private HandshakeFinishedMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handshakeCompleted(HandshakeCompletedEvent event) {
            Object object = this.lock;
            synchronized (object) {
                this.isFinished = true;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFinished() throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                while (!this.isFinished) {
                    this.lock.wait();
                }
            }
        }
    }
}

