/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.crypto;

import com.subgraph.orchid.TorException;
import com.subgraph.orchid.crypto.TorPublicKey;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class TorPrivateKey {
    private final TorPublicKey publicKey;
    private final RSAPrivateKey privateKey;

    public static TorPrivateKey generateNewKeypair() {
        KeyPairGenerator generator = TorPrivateKey.createGenerator();
        generator.initialize(1024, new SecureRandom());
        KeyPair pair = generator.generateKeyPair();
        return new TorPrivateKey((RSAPrivateKey)pair.getPrivate(), (RSAPublicKey)pair.getPublic());
    }

    static KeyPairGenerator createGenerator() {
        try {
            return KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new TorException(e);
        }
    }

    TorPrivateKey(RSAPrivateKey privateKey, RSAPublicKey publicKey) {
        this.privateKey = privateKey;
        this.publicKey = new TorPublicKey(publicKey);
    }

    public TorPublicKey getPublicKey() {
        return this.publicKey;
    }

    public RSAPublicKey getRSAPublicKey() {
        return this.publicKey.getRSAPublicKey();
    }

    public RSAPrivateKey getRSAPrivateKey() {
        return this.privateKey;
    }
}

