/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory;

import com.subgraph.orchid.ConsensusDocument;
import com.subgraph.orchid.Descriptor;
import com.subgraph.orchid.Directory;
import com.subgraph.orchid.DirectoryServer;
import com.subgraph.orchid.DirectoryStore;
import com.subgraph.orchid.GuardEntry;
import com.subgraph.orchid.KeyCertificate;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.RouterDescriptor;
import com.subgraph.orchid.RouterMicrodescriptor;
import com.subgraph.orchid.RouterStatus;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.TorException;
import com.subgraph.orchid.crypto.TorRandom;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.data.RandomSet;
import com.subgraph.orchid.directory.DescriptorCache;
import com.subgraph.orchid.directory.DirectoryStoreImpl;
import com.subgraph.orchid.directory.DocumentParserFactoryImpl;
import com.subgraph.orchid.directory.RouterImpl;
import com.subgraph.orchid.directory.StateFile;
import com.subgraph.orchid.directory.TrustedAuthorities;
import com.subgraph.orchid.directory.parsing.DocumentParser;
import com.subgraph.orchid.directory.parsing.DocumentParserFactory;
import com.subgraph.orchid.directory.parsing.DocumentParsingResult;
import com.subgraph.orchid.events.Event;
import com.subgraph.orchid.events.EventHandler;
import com.subgraph.orchid.events.EventManager;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class DirectoryImpl
implements Directory {
    private static final Logger logger = Logger.getLogger(DirectoryImpl.class.getName());
    private final Object loadLock = new Object();
    private boolean isLoaded = false;
    private final DirectoryStore store;
    private final TorConfig config;
    private final StateFile stateFile;
    private final DescriptorCache<RouterMicrodescriptor> microdescriptorCache;
    private final DescriptorCache<RouterDescriptor> basicDescriptorCache;
    private final Map<HexDigest, RouterImpl> routersByIdentity;
    private final Map<String, RouterImpl> routersByNickname;
    private final RandomSet<RouterImpl> directoryCaches;
    private final Set<ConsensusDocument.RequiredCertificate> requiredCertificates;
    private boolean haveMinimumRouterInfo;
    private boolean needRecalculateMinimumRouterInfo;
    private final EventManager consensusChangedManager;
    private final TorRandom random;
    private static final DocumentParserFactory parserFactory = new DocumentParserFactoryImpl();
    private ConsensusDocument currentConsensus;
    private ConsensusDocument consensusWaitingForCertificates;
    private long last = 0L;

    public DirectoryImpl(TorConfig config, DirectoryStore customDirectoryStore) {
        this.store = customDirectoryStore == null ? new DirectoryStoreImpl(config) : customDirectoryStore;
        this.config = config;
        this.stateFile = new StateFile(this.store, this);
        this.microdescriptorCache = DirectoryImpl.createMicrodescriptorCache(this.store);
        this.basicDescriptorCache = DirectoryImpl.createBasicDescriptorCache(this.store);
        this.routersByIdentity = new HashMap<HexDigest, RouterImpl>();
        this.routersByNickname = new HashMap<String, RouterImpl>();
        this.directoryCaches = new RandomSet();
        this.requiredCertificates = new HashSet<ConsensusDocument.RequiredCertificate>();
        this.consensusChangedManager = new EventManager();
        this.random = new TorRandom();
    }

    private static DescriptorCache<RouterMicrodescriptor> createMicrodescriptorCache(DirectoryStore store) {
        return new DescriptorCache<RouterMicrodescriptor>(store, DirectoryStore.CacheFile.MICRODESCRIPTOR_CACHE, DirectoryStore.CacheFile.MICRODESCRIPTOR_JOURNAL){

            @Override
            protected DocumentParser<RouterMicrodescriptor> createDocumentParser(ByteBuffer buffer) {
                return parserFactory.createRouterMicrodescriptorParser(buffer);
            }
        };
    }

    private static DescriptorCache<RouterDescriptor> createBasicDescriptorCache(DirectoryStore store) {
        return new DescriptorCache<RouterDescriptor>(store, DirectoryStore.CacheFile.DESCRIPTOR_CACHE, DirectoryStore.CacheFile.DESCRIPTOR_JOURNAL){

            @Override
            protected DocumentParser<RouterDescriptor> createDocumentParser(ByteBuffer buffer) {
                return parserFactory.createRouterDescriptorParser(buffer, false);
            }
        };
    }

    @Override
    public synchronized boolean haveMinimumRouterInfo() {
        if (this.needRecalculateMinimumRouterInfo) {
            this.checkMinimumRouterInfo();
        }
        return this.haveMinimumRouterInfo;
    }

    private synchronized void checkMinimumRouterInfo() {
        if (this.currentConsensus == null || !this.currentConsensus.isLive()) {
            this.needRecalculateMinimumRouterInfo = true;
            this.haveMinimumRouterInfo = false;
            return;
        }
        int routerCount = 0;
        int descriptorCount = 0;
        for (Router router : this.routersByIdentity.values()) {
            ++routerCount;
            if (router.isDescriptorDownloadable()) continue;
            ++descriptorCount;
        }
        this.needRecalculateMinimumRouterInfo = false;
        this.haveMinimumRouterInfo = descriptorCount * 4 > routerCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFromStore() {
        logger.info("Loading cached network information from disk");
        Object object = this.loadLock;
        synchronized (object) {
            if (this.isLoaded) {
                return;
            }
            boolean useMicrodescriptors = this.config.getUseMicrodescriptors() != TorConfig.AutoBoolValue.FALSE;
            this.last = System.currentTimeMillis();
            logger.info("Loading certificates");
            this.loadCertificates(this.store.loadCacheFile(DirectoryStore.CacheFile.CERTIFICATES));
            this.logElapsed();
            logger.info("Loading consensus");
            this.loadConsensus(this.store.loadCacheFile(useMicrodescriptors ? DirectoryStore.CacheFile.CONSENSUS_MICRODESC : DirectoryStore.CacheFile.CONSENSUS));
            this.logElapsed();
            if (!useMicrodescriptors) {
                logger.info("Loading descriptors");
                this.basicDescriptorCache.initialLoad();
            } else {
                logger.info("Loading microdescriptor cache");
                this.microdescriptorCache.initialLoad();
            }
            this.needRecalculateMinimumRouterInfo = true;
            this.logElapsed();
            logger.info("loading state file");
            this.stateFile.parseBuffer(this.store.loadCacheFile(DirectoryStore.CacheFile.STATE));
            this.logElapsed();
            this.isLoaded = true;
            this.loadLock.notifyAll();
        }
    }

    @Override
    public void close() {
        this.basicDescriptorCache.shutdown();
        this.microdescriptorCache.shutdown();
    }

    private void logElapsed() {
        long now = System.currentTimeMillis();
        long elapsed = now - this.last;
        this.last = now;
        logger.fine("Loaded in " + elapsed + " ms.");
    }

    private void loadCertificates(ByteBuffer buffer) {
        DocumentParser<KeyCertificate> parser = parserFactory.createKeyCertificateParser(buffer);
        DocumentParsingResult<KeyCertificate> result = parser.parse();
        if (this.testResult(result, "certificates")) {
            for (KeyCertificate cert : result.getParsedDocuments()) {
                this.addCertificate(cert);
            }
        }
    }

    private void loadConsensus(ByteBuffer buffer) {
        DocumentParser<ConsensusDocument> parser = parserFactory.createConsensusDocumentParser(buffer);
        DocumentParsingResult<ConsensusDocument> result = parser.parse();
        if (this.testResult(result, "consensus")) {
            this.addConsensusDocument(result.getDocument(), true);
        }
    }

    private boolean testResult(DocumentParsingResult<?> result, String type) {
        if (result.isOkay()) {
            return true;
        }
        if (result.isError()) {
            logger.warning("Parsing error loading " + type + " : " + result.getMessage());
        } else if (result.isInvalid()) {
            logger.warning("Problem loading " + type + " : " + result.getMessage());
        } else {
            logger.warning("Unknown problem loading " + type);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitUntilLoaded() {
        Object object = this.loadLock;
        synchronized (object) {
            while (!this.isLoaded) {
                try {
                    this.loadLock.wait();
                }
                catch (InterruptedException e) {
                    logger.warning("Thread interrupted while waiting for directory to load from disk");
                }
            }
        }
    }

    @Override
    public Collection<DirectoryServer> getDirectoryAuthorities() {
        return TrustedAuthorities.getInstance().getAuthorityServers();
    }

    @Override
    public DirectoryServer getRandomDirectoryAuthority() {
        List<DirectoryServer> servers = TrustedAuthorities.getInstance().getAuthorityServers();
        int idx = this.random.nextInt(servers.size());
        return servers.get(idx);
    }

    @Override
    public Set<ConsensusDocument.RequiredCertificate> getRequiredCertificates() {
        return new HashSet<ConsensusDocument.RequiredCertificate>(this.requiredCertificates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCertificate(KeyCertificate certificate) {
        TrustedAuthorities trustedAuthorities = TrustedAuthorities.getInstance();
        synchronized (trustedAuthorities) {
            boolean wasRequired = this.removeRequiredCertificate(certificate);
            DirectoryServer as = TrustedAuthorities.getInstance().getAuthorityServerByIdentity(certificate.getAuthorityFingerprint());
            if (as == null) {
                logger.warning("Certificate read for unknown directory authority with identity: " + certificate.getAuthorityFingerprint());
                return;
            }
            as.addCertificate(certificate);
            if (this.consensusWaitingForCertificates != null && wasRequired) {
                switch (this.consensusWaitingForCertificates.verifySignatures()) {
                    case STATUS_FAILED: {
                        this.consensusWaitingForCertificates = null;
                        return;
                    }
                    case STATUS_VERIFIED: {
                        this.addConsensusDocument(this.consensusWaitingForCertificates, false);
                        this.consensusWaitingForCertificates = null;
                        return;
                    }
                    case STATUS_NEED_CERTS: {
                        this.requiredCertificates.addAll(this.consensusWaitingForCertificates.getRequiredCertificates());
                        return;
                    }
                }
            }
        }
    }

    private boolean removeRequiredCertificate(KeyCertificate certificate) {
        Iterator<ConsensusDocument.RequiredCertificate> it = this.requiredCertificates.iterator();
        while (it.hasNext()) {
            ConsensusDocument.RequiredCertificate r = it.next();
            if (!r.getSigningKey().equals(certificate.getAuthoritySigningKey().getFingerprint())) continue;
            it.remove();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeCertificates() {
        TrustedAuthorities trustedAuthorities = TrustedAuthorities.getInstance();
        synchronized (trustedAuthorities) {
            ArrayList<KeyCertificate> certs = new ArrayList<KeyCertificate>();
            for (DirectoryServer ds : TrustedAuthorities.getInstance().getAuthorityServers()) {
                certs.addAll(ds.getCertificates());
            }
            this.store.writeDocumentList(DirectoryStore.CacheFile.CERTIFICATES, certs);
        }
    }

    @Override
    public void addRouterDescriptors(List<RouterDescriptor> descriptors) {
        this.basicDescriptorCache.addDescriptors(descriptors);
        this.needRecalculateMinimumRouterInfo = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addConsensusDocument(ConsensusDocument consensus, boolean fromCache) {
        if (consensus.equals(this.currentConsensus)) {
            return;
        }
        if (this.currentConsensus != null && consensus.getValidAfterTime().isBefore(this.currentConsensus.getValidAfterTime())) {
            logger.warning("New consensus document is older than current consensus document");
            return;
        }
        TrustedAuthorities trustedAuthorities = TrustedAuthorities.getInstance();
        synchronized (trustedAuthorities) {
            switch (consensus.verifySignatures()) {
                case STATUS_FAILED: {
                    logger.warning("Unable to verify signatures on consensus document, discarding...");
                    return;
                }
                case STATUS_NEED_CERTS: {
                    this.consensusWaitingForCertificates = consensus;
                    this.requiredCertificates.addAll(consensus.getRequiredCertificates());
                    return;
                }
            }
            this.requiredCertificates.addAll(consensus.getRequiredCertificates());
        }
        HashMap<HexDigest, RouterImpl> oldRouterByIdentity = new HashMap<HexDigest, RouterImpl>(this.routersByIdentity);
        this.clearAll();
        for (RouterStatus status : consensus.getRouterStatusEntries()) {
            Descriptor d;
            if (status.hasFlag("Running") && status.hasFlag("Valid")) {
                RouterImpl router = this.updateOrCreateRouter(status, oldRouterByIdentity);
                this.addRouter(router);
                this.classifyRouter(router);
            }
            if ((d = this.getDescriptorForRouterStatus(status, consensus.getFlavor() == ConsensusDocument.ConsensusFlavor.MICRODESC)) == null) continue;
            d.setLastListed(consensus.getValidAfterTime().getTime());
        }
        logger.fine("Loaded " + this.routersByIdentity.size() + " routers from consensus document");
        this.currentConsensus = consensus;
        if (!fromCache) {
            this.storeCurrentConsensus();
        }
        this.consensusChangedManager.fireEvent(new Event(){});
    }

    private void storeCurrentConsensus() {
        if (this.currentConsensus != null) {
            if (this.currentConsensus.getFlavor() == ConsensusDocument.ConsensusFlavor.MICRODESC) {
                this.store.writeDocument(DirectoryStore.CacheFile.CONSENSUS_MICRODESC, this.currentConsensus);
            } else {
                this.store.writeDocument(DirectoryStore.CacheFile.CONSENSUS, this.currentConsensus);
            }
        }
    }

    private Descriptor getDescriptorForRouterStatus(RouterStatus rs, boolean isMicrodescriptor) {
        if (isMicrodescriptor) {
            return this.microdescriptorCache.getDescriptor(rs.getMicrodescriptorDigest());
        }
        return this.basicDescriptorCache.getDescriptor(rs.getDescriptorDigest());
    }

    private RouterImpl updateOrCreateRouter(RouterStatus status, Map<HexDigest, RouterImpl> knownRouters) {
        RouterImpl router = knownRouters.get(status.getIdentity());
        if (router == null) {
            return RouterImpl.createFromRouterStatus(this, status);
        }
        router.updateStatus(status);
        return router;
    }

    private void clearAll() {
        this.routersByIdentity.clear();
        this.routersByNickname.clear();
        this.directoryCaches.clear();
    }

    private void classifyRouter(RouterImpl router) {
        if (this.isValidDirectoryCache(router)) {
            this.directoryCaches.add(router);
        } else {
            this.directoryCaches.remove(router);
        }
    }

    private boolean isValidDirectoryCache(RouterImpl router) {
        if (router.getDirectoryPort() == 0) {
            return false;
        }
        if (router.hasFlag("BadDirectory")) {
            return false;
        }
        return router.hasFlag("V2Dir");
    }

    private void addRouter(RouterImpl router) {
        this.routersByIdentity.put(router.getIdentityHash(), router);
        this.addRouterByNickname(router);
    }

    private void addRouterByNickname(RouterImpl router) {
        String name = router.getNickname();
        if (name == null || name.equals("Unnamed")) {
            return;
        }
        if (this.routersByNickname.containsKey(router.getNickname())) {
            return;
        }
        this.routersByNickname.put(name, router);
    }

    @Override
    public synchronized void addRouterMicrodescriptors(List<RouterMicrodescriptor> microdescriptors) {
        this.microdescriptorCache.addDescriptors(microdescriptors);
        this.needRecalculateMinimumRouterInfo = true;
    }

    @Override
    public synchronized List<Router> getRoutersWithDownloadableDescriptors() {
        this.waitUntilLoaded();
        ArrayList<Router> routers = new ArrayList<Router>();
        for (RouterImpl router : this.routersByIdentity.values()) {
            if (!router.isDescriptorDownloadable()) continue;
            routers.add(router);
        }
        for (int i = 0; i < routers.size(); ++i) {
            Router a = (Router)routers.get(i);
            int swapIdx = this.random.nextInt(routers.size());
            Router b = (Router)routers.get(swapIdx);
            routers.set(i, b);
            routers.set(swapIdx, a);
        }
        return routers;
    }

    @Override
    public ConsensusDocument getCurrentConsensusDocument() {
        return this.currentConsensus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPendingConsensus() {
        TrustedAuthorities trustedAuthorities = TrustedAuthorities.getInstance();
        synchronized (trustedAuthorities) {
            return this.consensusWaitingForCertificates != null;
        }
    }

    @Override
    public void registerConsensusChangedHandler(EventHandler handler) {
        this.consensusChangedManager.addListener(handler);
    }

    @Override
    public void unregisterConsensusChangedHandler(EventHandler handler) {
        this.consensusChangedManager.removeListener(handler);
    }

    @Override
    public Router getRouterByName(String name) {
        if (name.equals("Unnamed")) {
            return null;
        }
        if (name.length() == 41 && name.charAt(0) == '$') {
            try {
                HexDigest identity = HexDigest.createFromString(name.substring(1));
                return this.getRouterByIdentity(identity);
            }
            catch (Exception e) {
                return null;
            }
        }
        this.waitUntilLoaded();
        return this.routersByNickname.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Router getRouterByIdentity(HexDigest identity) {
        this.waitUntilLoaded();
        Map<HexDigest, RouterImpl> map = this.routersByIdentity;
        synchronized (map) {
            return this.routersByIdentity.get(identity);
        }
    }

    @Override
    public List<Router> getRouterListByNames(List<String> names) {
        this.waitUntilLoaded();
        ArrayList<Router> routers = new ArrayList<Router>();
        for (String n : names) {
            Router r = this.getRouterByName(n);
            if (r == null) {
                throw new TorException("Could not find router named: " + n);
            }
            routers.add(r);
        }
        return routers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Router> getAllRouters() {
        this.waitUntilLoaded();
        Map<HexDigest, RouterImpl> map = this.routersByIdentity;
        synchronized (map) {
            return new ArrayList<Router>(this.routersByIdentity.values());
        }
    }

    @Override
    public GuardEntry createGuardEntryFor(Router router) {
        this.waitUntilLoaded();
        return this.stateFile.createGuardEntryFor(router);
    }

    @Override
    public List<GuardEntry> getGuardEntries() {
        this.waitUntilLoaded();
        return this.stateFile.getGuardEntries();
    }

    @Override
    public void removeGuardEntry(GuardEntry entry) {
        this.waitUntilLoaded();
        this.stateFile.removeGuardEntry(entry);
    }

    @Override
    public void addGuardEntry(GuardEntry entry) {
        this.waitUntilLoaded();
        this.stateFile.addGuardEntry(entry);
    }

    @Override
    public RouterMicrodescriptor getMicrodescriptorFromCache(HexDigest descriptorDigest) {
        return this.microdescriptorCache.getDescriptor(descriptorDigest);
    }

    @Override
    public RouterDescriptor getBasicDescriptorFromCache(HexDigest descriptorDigest) {
        return this.basicDescriptorCache.getDescriptor(descriptorDigest);
    }
}

