/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory;

import com.subgraph.orchid.Directory;
import com.subgraph.orchid.DirectoryStore;
import com.subgraph.orchid.GuardEntry;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.Tor;
import com.subgraph.orchid.crypto.TorRandom;
import com.subgraph.orchid.directory.GuardEntryImpl;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

public class StateFile {
    private static final Logger logger = Logger.getLogger(StateFile.class.getName());
    private static final int DATE_LENGTH = 19;
    static final String KEYWORD_ENTRY_GUARD = "EntryGuard";
    static final String KEYWORD_ENTRY_GUARD_ADDED_BY = "EntryGuardAddedBy";
    static final String KEYWORD_ENTRY_GUARD_DOWN_SINCE = "EntryGuardDownSince";
    static final String KEYWORD_ENTRY_GUARD_UNLISTED_SINCE = "EntryGuardUnlistedSince";
    private final List<GuardEntryImpl> guardEntries = new ArrayList<GuardEntryImpl>();
    private final TorRandom random = new TorRandom();
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final DirectoryStore directoryStore;
    private final Directory directory;

    String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    StateFile(DirectoryStore store, Directory directory) {
        this.directoryStore = store;
        this.directory = directory;
    }

    public GuardEntry createGuardEntryFor(Router router) {
        GuardEntryImpl entry = new GuardEntryImpl(this.directory, this, router.getNickname(), router.getIdentityHash().toString());
        String version = Tor.getImplementation() + "-" + Tor.getVersion();
        entry.setVersion(version);
        long createTime = new Date().getTime() - (long)this.random.nextInt(2592000) * 1000L;
        entry.setCreatedTime(new Date(createTime));
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GuardEntry> getGuardEntries() {
        List<GuardEntryImpl> list = this.guardEntries;
        synchronized (list) {
            return new ArrayList<GuardEntry>(this.guardEntries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGuardEntry(GuardEntry entry) {
        List<GuardEntryImpl> list = this.guardEntries;
        synchronized (list) {
            this.guardEntries.remove(entry);
            this.writeFile();
        }
    }

    public void addGuardEntry(GuardEntry entry) {
        this.addGuardEntry(entry, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGuardEntry(GuardEntry entry, boolean writeFile) {
        List<GuardEntryImpl> list = this.guardEntries;
        synchronized (list) {
            if (this.guardEntries.contains(entry)) {
                return;
            }
            GuardEntryImpl impl = (GuardEntryImpl)entry;
            this.guardEntries.add(impl);
            GuardEntryImpl guardEntryImpl = impl;
            synchronized (guardEntryImpl) {
                impl.setAddedFlag();
                if (writeFile) {
                    this.writeFile();
                }
            }
        }
    }

    void writeFile() {
        this.directoryStore.writeData(DirectoryStore.CacheFile.STATE, this.getFileContents());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer getFileContents() {
        StringBuilder sb = new StringBuilder();
        List<GuardEntryImpl> list = this.guardEntries;
        synchronized (list) {
            for (GuardEntryImpl entry : this.guardEntries) {
                sb.append(entry.writeToString());
            }
        }
        return ByteBuffer.wrap(sb.toString().getBytes(Tor.getDefaultCharset()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseBuffer(ByteBuffer buffer) {
        List<GuardEntryImpl> list = this.guardEntries;
        synchronized (list) {
            this.guardEntries.clear();
            this.loadGuardEntries(buffer);
        }
    }

    private void loadGuardEntries(ByteBuffer buffer) {
        GuardEntryImpl currentEntry = null;
        while (true) {
            Line line;
            if ((line = this.readLine(buffer)) == null) {
                this.addEntryIfValid(currentEntry);
                return;
            }
            currentEntry = this.processLine(line, currentEntry);
        }
    }

    private GuardEntryImpl processLine(Line line, GuardEntryImpl current) {
        String keyword = line.nextToken();
        if (keyword == null) {
            return current;
        }
        if (keyword.equals(KEYWORD_ENTRY_GUARD)) {
            this.addEntryIfValid(current);
            GuardEntryImpl newEntry = this.processEntryGuardLine(line);
            if (newEntry == null) {
                return current;
            }
            return newEntry;
        }
        if (keyword.equals(KEYWORD_ENTRY_GUARD_ADDED_BY)) {
            this.processEntryGuardAddedBy(line, current);
            return current;
        }
        if (keyword.equals(KEYWORD_ENTRY_GUARD_DOWN_SINCE)) {
            this.processEntryGuardDownSince(line, current);
            return current;
        }
        if (keyword.equals(KEYWORD_ENTRY_GUARD_UNLISTED_SINCE)) {
            this.processEntryGuardUnlistedSince(line, current);
            return current;
        }
        return current;
    }

    private GuardEntryImpl processEntryGuardLine(Line line) {
        String name = line.nextToken();
        String identity = line.nextToken();
        if (name == null || name.isEmpty() || identity == null || identity.isEmpty()) {
            logger.warning("Failed to parse EntryGuard line: " + line.line);
            return null;
        }
        return new GuardEntryImpl(this.directory, this, name, identity);
    }

    private void processEntryGuardAddedBy(Line line, GuardEntryImpl current) {
        if (current == null) {
            logger.warning("EntryGuardAddedBy line seen before EntryGuard in state file");
            return;
        }
        String identity = line.nextToken();
        String version = line.nextToken();
        Date created = line.parseDate();
        if (identity == null || identity.isEmpty() || version == null || version.isEmpty() || created == null) {
            logger.warning("Missing EntryGuardAddedBy field in state file");
            return;
        }
        current.setVersion(version);
        current.setCreatedTime(created);
    }

    private void processEntryGuardDownSince(Line line, GuardEntryImpl current) {
        if (current == null) {
            logger.warning("EntryGuardDownSince line seen before EntryGuard in state file");
            return;
        }
        Date downSince = line.parseDate();
        Date lastTried = line.parseDate();
        if (downSince == null) {
            logger.warning("Failed to parse date field in EntryGuardDownSince line in state file");
            return;
        }
        current.setDownSince(downSince, lastTried);
    }

    private void processEntryGuardUnlistedSince(Line line, GuardEntryImpl current) {
        if (current == null) {
            logger.warning("EntryGuardUnlistedSince line seen before EntryGuard in state file");
            return;
        }
        Date unlistedSince = line.parseDate();
        if (unlistedSince == null) {
            logger.warning("Failed to parse date field in EntryGuardUnlistedSince line in state file");
            return;
        }
        current.setUnlistedSince(unlistedSince);
    }

    private void addEntryIfValid(GuardEntryImpl entry) {
        if (this.isValidEntry(entry)) {
            this.addGuardEntry(entry, false);
        }
    }

    private boolean isValidEntry(GuardEntryImpl entry) {
        return entry != null && entry.getNickname() != null && entry.getIdentity() != null && entry.getVersion() != null && entry.getCreatedTime() != null;
    }

    private Line readLine(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (buffer.hasRemaining()) {
            char c = (char)(buffer.get() & 0xFF);
            if (c == '\n') {
                return new Line(sb.toString());
            }
            if (c == '\r') continue;
            sb.append(c);
        }
        return new Line(sb.toString());
    }

    private class Line {
        final String line;
        int offset;

        Line(String line) {
            this.line = line;
            this.offset = 0;
        }

        private boolean hasChars() {
            return this.offset < this.line.length();
        }

        private char getChar() {
            return this.line.charAt(this.offset);
        }

        private void incrementOffset(int n) {
            this.offset += n;
            if (this.offset > this.line.length()) {
                this.offset = this.line.length();
            }
        }

        private void skipWhitespace() {
            while (this.hasChars() && Character.isWhitespace(this.getChar())) {
                ++this.offset;
            }
        }

        String nextToken() {
            this.skipWhitespace();
            if (!this.hasChars()) {
                return null;
            }
            StringBuilder token = new StringBuilder();
            while (this.hasChars() && !Character.isWhitespace(this.getChar())) {
                token.append(this.getChar());
                ++this.offset;
            }
            return token.toString();
        }

        Date parseDate() {
            this.skipWhitespace();
            if (!this.hasChars()) {
                return null;
            }
            try {
                Date date = StateFile.this.dateFormat.parse(this.line.substring(this.offset));
                this.incrementOffset(19);
                return date;
            }
            catch (ParseException e) {
                return null;
            }
        }
    }
}

