/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.router;

import com.subgraph.orchid.Descriptor;
import com.subgraph.orchid.RouterDescriptor;
import com.subgraph.orchid.Tor;
import com.subgraph.orchid.crypto.TorPublicKey;
import com.subgraph.orchid.data.BandwidthHistory;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.data.IPv4Address;
import com.subgraph.orchid.data.Timestamp;
import com.subgraph.orchid.data.exitpolicy.ExitPolicy;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RouterDescriptorImpl
implements RouterDescriptor {
    private String nickname;
    private IPv4Address address;
    private int routerPort;
    private int directoryPort;
    private int averageBandwidth = -1;
    private int burstBandwidth = -1;
    private int observedBandwidth = -1;
    private String platform;
    private Timestamp published;
    private HexDigest fingerprint;
    private boolean hibernating;
    private int uptime;
    private TorPublicKey onionKey;
    private byte[] ntorOnionKey;
    private TorPublicKey identityKey;
    private ExitPolicy exitPolicy = new ExitPolicy();
    private String contact;
    private Set<String> familyMembers = Collections.emptySet();
    private Set<Integer> linkProtocols = Collections.emptySet();
    private Set<Integer> circuitProtocols = Collections.emptySet();
    private BandwidthHistory readHistory;
    private BandwidthHistory writeHistory;
    private boolean eventDNS = false;
    private boolean cachesExtraInfo = false;
    private boolean hiddenServiceDir = false;
    private HexDigest extraInfoDigest = null;
    private boolean allowSingleHopExits = false;
    private boolean hasValidSignature = false;
    private HexDigest descriptorDigest;
    private String rawDocumentData;
    private long lastListed;
    private Descriptor.CacheLocation cacheLocation = Descriptor.CacheLocation.NOT_CACHED;

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setAddress(IPv4Address address) {
        this.address = address;
    }

    public void setRouterPort(int port) {
        this.routerPort = port;
    }

    void setDirectoryPort(int port) {
        this.directoryPort = port;
    }

    void setPlatform(String platform) {
        this.platform = platform;
    }

    void setPublished(Timestamp published) {
        this.published = published;
    }

    void setFingerprint(HexDigest fingerprint) {
        this.fingerprint = fingerprint;
    }

    void setHibernating(boolean flag) {
        this.hibernating = flag;
    }

    void setUptime(int uptime) {
        this.uptime = uptime;
    }

    public void setOnionKey(TorPublicKey key) {
        this.onionKey = key;
    }

    void setNtorOnionKey(byte[] key) {
        this.ntorOnionKey = key;
    }

    void setIdentityKey(TorPublicKey key) {
        this.identityKey = key;
    }

    void setContact(String contact) {
        this.contact = contact;
    }

    void setEventDNS() {
        this.eventDNS = true;
    }

    void setHiddenServiceDir() {
        this.hiddenServiceDir = true;
    }

    void setExtraInfoDigest(HexDigest digest) {
        this.extraInfoDigest = digest;
    }

    void setCachesExtraInfo() {
        this.cachesExtraInfo = true;
    }

    void setAllowSingleHopExits() {
        this.allowSingleHopExits = true;
    }

    void setReadHistory(BandwidthHistory history) {
        this.readHistory = history;
    }

    void setWriteHistory(BandwidthHistory history) {
        this.writeHistory = history;
    }

    void setValidSignature() {
        this.hasValidSignature = true;
    }

    void setDescriptorHash(HexDigest digest) {
        this.descriptorDigest = digest;
    }

    void setRawDocumentData(String rawData) {
        this.rawDocumentData = rawData;
    }

    void addAcceptRule(String rule) {
        this.exitPolicy.addAcceptRule(rule);
    }

    void addRejectRule(String rule) {
        this.exitPolicy.addRejectRule(rule);
    }

    void setBandwidthValues(int average, int burst, int observed) {
        this.averageBandwidth = average;
        this.burstBandwidth = burst;
        this.observedBandwidth = observed;
    }

    void addFamilyMember(String familyMember) {
        if (this.familyMembers.isEmpty()) {
            this.familyMembers = new HashSet<String>();
        }
        this.familyMembers.add(familyMember);
    }

    void addCircuitProtocolVersion(int version) {
        if (this.circuitProtocols.isEmpty()) {
            this.circuitProtocols = new HashSet<Integer>();
        }
        this.circuitProtocols.add(version);
    }

    void addLinkProtocolVersion(int version) {
        if (this.linkProtocols.isEmpty()) {
            this.linkProtocols = new HashSet<Integer>();
        }
        this.linkProtocols.add(version);
    }

    @Override
    public boolean isValidDocument() {
        return this.hasValidSignature && this.nickname != null && this.address != null && this.averageBandwidth != -1 && (this.routerPort != 0 || this.directoryPort != 0) && this.published != null && this.onionKey != null && this.identityKey != null && this.descriptorDigest != null;
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public IPv4Address getAddress() {
        return this.address;
    }

    @Override
    public int getRouterPort() {
        return this.routerPort;
    }

    @Override
    public int getDirectoryPort() {
        return this.directoryPort;
    }

    @Override
    public int getAverageBandwidth() {
        return this.averageBandwidth;
    }

    @Override
    public int getBurstBandwidth() {
        return this.burstBandwidth;
    }

    @Override
    public int getObservedBandwidth() {
        return this.observedBandwidth;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    @Override
    public HexDigest getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public int getUptime() {
        return this.uptime;
    }

    @Override
    public TorPublicKey getOnionKey() {
        return this.onionKey;
    }

    @Override
    public byte[] getNTorOnionKey() {
        return this.ntorOnionKey;
    }

    @Override
    public TorPublicKey getIdentityKey() {
        return this.identityKey;
    }

    @Override
    public String getContact() {
        return this.contact;
    }

    @Override
    public boolean isHibernating() {
        return this.hibernating;
    }

    @Override
    public boolean cachesExtraInfo() {
        return this.cachesExtraInfo;
    }

    @Override
    public boolean allowsSingleHopExits() {
        return this.allowSingleHopExits;
    }

    @Override
    public Timestamp getPublishedTime() {
        return this.published;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Router Descriptor: (name: ");
        builder.append(this.nickname);
        builder.append(" orport=");
        builder.append(this.routerPort);
        builder.append(" dirport=");
        builder.append(this.directoryPort);
        builder.append(" address=");
        builder.append(this.address);
        builder.append(" platform=");
        builder.append(this.platform);
        builder.append(" published=");
        builder.append(this.published.getDate());
        builder.append(")");
        return builder.toString();
    }

    public void print() {
        System.out.println("nickname: " + this.nickname + " IP: " + this.address + " port: " + this.routerPort);
        System.out.println("directory port: " + this.directoryPort + " platform: " + this.platform);
        System.out.println("Bandwidth(avg/burst/observed): " + this.averageBandwidth + "/" + this.burstBandwidth + "/" + this.observedBandwidth);
        System.out.println("Publication time: " + this.published + " Uptime: " + this.uptime);
        if (this.fingerprint != null) {
            System.out.println("Fingerprint: " + this.fingerprint);
        }
        if (this.contact != null) {
            System.out.println("Contact: " + this.contact);
        }
    }

    @Override
    public boolean exitPolicyAccepts(IPv4Address address, int port) {
        return this.exitPolicy.acceptsDestination(address, port);
    }

    @Override
    public boolean exitPolicyAccepts(int port) {
        return this.exitPolicy.acceptsPort(port);
    }

    @Override
    public HexDigest getExtraInfoDigest() {
        return this.extraInfoDigest;
    }

    @Override
    public boolean isHiddenServiceDirectory() {
        return this.hiddenServiceDir;
    }

    @Override
    public Set<String> getFamilyMembers() {
        return this.familyMembers;
    }

    @Override
    public boolean supportsEventDNS() {
        return this.eventDNS;
    }

    public BandwidthHistory getReadHistory() {
        return this.readHistory;
    }

    public BandwidthHistory getWriteHistory() {
        return this.writeHistory;
    }

    @Override
    public boolean isNewerThan(RouterDescriptor other) {
        return other.getPublishedTime().isBefore(this.published);
    }

    @Override
    public HexDigest getDescriptorDigest() {
        return this.descriptorDigest;
    }

    @Override
    public String getRawDocumentData() {
        return this.rawDocumentData;
    }

    @Override
    public ByteBuffer getRawDocumentBytes() {
        if (this.getRawDocumentData() == null) {
            return ByteBuffer.allocate(0);
        }
        return ByteBuffer.wrap(this.getRawDocumentData().getBytes(Tor.getDefaultCharset()));
    }

    public boolean equals(Object o) {
        if (!(o instanceof RouterDescriptorImpl)) {
            return false;
        }
        RouterDescriptorImpl other = (RouterDescriptorImpl)o;
        if (other.getDescriptorDigest() == null || this.descriptorDigest == null) {
            return false;
        }
        return other.getDescriptorDigest().equals(this.descriptorDigest);
    }

    public int hashCode() {
        if (this.descriptorDigest == null) {
            return 0;
        }
        return this.descriptorDigest.hashCode();
    }

    @Override
    public ExitPolicy getExitPolicy() {
        return this.exitPolicy;
    }

    @Override
    public void setLastListed(long timestamp) {
        this.lastListed = timestamp;
    }

    @Override
    public long getLastListed() {
        return this.lastListed;
    }

    @Override
    public void setCacheLocation(Descriptor.CacheLocation location) {
        this.cacheLocation = location;
    }

    @Override
    public Descriptor.CacheLocation getCacheLocation() {
        return this.cacheLocation;
    }

    @Override
    public int getBodyLength() {
        return this.rawDocumentData.length();
    }
}

