/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.router;

import com.subgraph.orchid.RouterDescriptor;
import com.subgraph.orchid.TorParsingException;
import com.subgraph.orchid.crypto.TorSignature;
import com.subgraph.orchid.data.BandwidthHistory;
import com.subgraph.orchid.data.Timestamp;
import com.subgraph.orchid.directory.parsing.BasicDocumentParsingResult;
import com.subgraph.orchid.directory.parsing.DocumentFieldParser;
import com.subgraph.orchid.directory.parsing.DocumentParser;
import com.subgraph.orchid.directory.parsing.DocumentParsingHandler;
import com.subgraph.orchid.directory.parsing.DocumentParsingResult;
import com.subgraph.orchid.directory.parsing.DocumentParsingResultHandler;
import com.subgraph.orchid.directory.router.RouterDescriptorImpl;
import com.subgraph.orchid.directory.router.RouterDescriptorKeyword;

public class RouterDescriptorParser
implements DocumentParser<RouterDescriptor> {
    private final DocumentFieldParser fieldParser;
    private final boolean verifySignatures;
    private RouterDescriptorImpl currentDescriptor;
    private DocumentParsingResultHandler<RouterDescriptor> resultHandler;

    public RouterDescriptorParser(DocumentFieldParser fieldParser, boolean verifySignatures) {
        this.fieldParser = fieldParser;
        this.fieldParser.setHandler(this.createParsingHandler());
        this.fieldParser.setRecognizeOpt();
        this.verifySignatures = verifySignatures;
    }

    private DocumentParsingHandler createParsingHandler() {
        return new DocumentParsingHandler(){

            @Override
            public void endOfDocument() {
            }

            @Override
            public void parseKeywordLine() {
                RouterDescriptorParser.this.processKeywordLine();
            }
        };
    }

    private void processKeywordLine() {
        RouterDescriptorKeyword keyword = RouterDescriptorKeyword.findKeyword(this.fieldParser.getCurrentKeyword());
        if (!keyword.equals((Object)RouterDescriptorKeyword.UNKNOWN_KEYWORD)) {
            this.processKeyword(keyword);
        }
    }

    private void startNewDescriptor() {
        this.fieldParser.resetRawDocument();
        this.fieldParser.startSignedEntity();
        this.currentDescriptor = new RouterDescriptorImpl();
    }

    @Override
    public boolean parse(DocumentParsingResultHandler<RouterDescriptor> resultHandler) {
        this.resultHandler = resultHandler;
        this.startNewDescriptor();
        try {
            this.fieldParser.processDocument();
            return true;
        }
        catch (TorParsingException e) {
            resultHandler.parsingError(e.getMessage());
            return false;
        }
    }

    @Override
    public DocumentParsingResult<RouterDescriptor> parse() {
        BasicDocumentParsingResult<RouterDescriptor> result = new BasicDocumentParsingResult<RouterDescriptor>();
        this.parse((DocumentParsingResultHandler<RouterDescriptor>)result);
        return result;
    }

    private void processKeyword(RouterDescriptorKeyword keyword) {
        this.fieldParser.verifyExpectedArgumentCount(keyword.getKeyword(), keyword.getArgumentCount());
        switch (keyword) {
            case ROUTER: {
                this.processRouter();
                return;
            }
            case BANDWIDTH: {
                this.processBandwidth();
                break;
            }
            case PLATFORM: {
                this.currentDescriptor.setPlatform(this.fieldParser.parseConcatenatedString());
                break;
            }
            case PUBLISHED: {
                this.currentDescriptor.setPublished(this.fieldParser.parseTimestamp());
                break;
            }
            case FINGERPRINT: {
                this.currentDescriptor.setFingerprint(this.fieldParser.parseFingerprint());
                break;
            }
            case HIBERNATING: {
                this.currentDescriptor.setHibernating(this.fieldParser.parseBoolean());
                break;
            }
            case UPTIME: {
                this.currentDescriptor.setUptime(this.fieldParser.parseInteger());
                break;
            }
            case ONION_KEY: {
                this.currentDescriptor.setOnionKey(this.fieldParser.parsePublicKey());
                break;
            }
            case NTOR_ONION_KEY: {
                this.currentDescriptor.setNtorOnionKey(this.fieldParser.parseNtorPublicKey());
                break;
            }
            case SIGNING_KEY: {
                this.currentDescriptor.setIdentityKey(this.fieldParser.parsePublicKey());
                break;
            }
            case ROUTER_SIGNATURE: {
                this.processSignature();
                break;
            }
            case ACCEPT: {
                this.currentDescriptor.addAcceptRule(this.fieldParser.parseString());
                break;
            }
            case REJECT: {
                this.currentDescriptor.addRejectRule(this.fieldParser.parseString());
                break;
            }
            case CONTACT: {
                this.currentDescriptor.setContact(this.fieldParser.parseConcatenatedString());
                break;
            }
            case FAMILY: {
                while (this.fieldParser.argumentsRemaining() > 0) {
                    this.currentDescriptor.addFamilyMember(this.fieldParser.parseString());
                }
                break;
            }
            case EVENTDNS: {
                if (!this.fieldParser.parseBoolean()) break;
                this.currentDescriptor.setEventDNS();
                break;
            }
            case PROTOCOLS: {
                this.processProtocols();
                break;
            }
            case CACHES_EXTRA_INFO: {
                this.currentDescriptor.setCachesExtraInfo();
                break;
            }
            case HIDDEN_SERVICE_DIR: {
                this.currentDescriptor.setHiddenServiceDir();
                break;
            }
            case ALLOW_SINGLE_HOP_EXITS: {
                this.currentDescriptor.setAllowSingleHopExits();
                break;
            }
            case EXTRA_INFO_DIGEST: {
                this.currentDescriptor.setExtraInfoDigest(this.fieldParser.parseHexDigest());
                break;
            }
            case READ_HISTORY: {
                this.currentDescriptor.setReadHistory(this.parseHistory());
                break;
            }
            case WRITE_HISTORY: {
                this.currentDescriptor.setWriteHistory(this.parseHistory());
                break;
            }
        }
    }

    private BandwidthHistory parseHistory() {
        String[] samples;
        Timestamp ts = this.fieldParser.parseTimestamp();
        String nsec = this.fieldParser.parseString();
        this.fieldParser.parseString();
        int interval = this.fieldParser.parseInteger(nsec.substring(1));
        BandwidthHistory history = new BandwidthHistory(ts, interval);
        if (this.fieldParser.argumentsRemaining() == 0) {
            return history;
        }
        for (String s : samples = this.fieldParser.parseString().split(",")) {
            history.addSample(this.fieldParser.parseInteger(s));
        }
        return history;
    }

    private void processRouter() {
        this.currentDescriptor.setNickname(this.fieldParser.parseNickname());
        this.currentDescriptor.setAddress(this.fieldParser.parseAddress());
        this.currentDescriptor.setRouterPort(this.fieldParser.parsePort());
        this.fieldParser.parsePort();
        this.currentDescriptor.setDirectoryPort(this.fieldParser.parsePort());
    }

    private boolean verifyCurrentDescriptor(TorSignature signature) {
        if (this.verifySignatures && !this.fieldParser.verifySignedEntity(this.currentDescriptor.getIdentityKey(), signature)) {
            this.resultHandler.documentInvalid(this.currentDescriptor, "Signature failed.");
            this.fieldParser.logWarn("Signature failed for router: " + this.currentDescriptor.getNickname());
            return false;
        }
        this.currentDescriptor.setValidSignature();
        if (!this.currentDescriptor.isValidDocument()) {
            this.resultHandler.documentInvalid(this.currentDescriptor, "Router data invalid");
            this.fieldParser.logWarn("Router data invalid for router: " + this.currentDescriptor.getNickname());
        }
        return this.currentDescriptor.isValidDocument();
    }

    private void processBandwidth() {
        int average = this.fieldParser.parseInteger();
        int burst = this.fieldParser.parseInteger();
        int observed = this.fieldParser.parseInteger();
        this.currentDescriptor.setBandwidthValues(average, burst, observed);
    }

    private void processProtocols() {
        String kw = this.fieldParser.parseString();
        if (!kw.equals("Link")) {
            throw new TorParsingException("Expected 'Link' token in protocol line got: " + kw);
        }
        while (!(kw = this.fieldParser.parseString()).equals("Circuit")) {
            this.currentDescriptor.addLinkProtocolVersion(this.fieldParser.parseInteger(kw));
        }
        while (this.fieldParser.argumentsRemaining() > 0) {
            this.currentDescriptor.addCircuitProtocolVersion(this.fieldParser.parseInteger());
        }
    }

    private void processSignature() {
        this.fieldParser.endSignedEntity();
        this.currentDescriptor.setDescriptorHash(this.fieldParser.getSignatureMessageDigest().getHexDigest());
        TorSignature signature = this.fieldParser.parseSignature();
        this.currentDescriptor.setRawDocumentData(this.fieldParser.getRawDocument());
        if (this.verifyCurrentDescriptor(signature)) {
            this.resultHandler.documentParsed(this.currentDescriptor);
        }
        this.startNewDescriptor();
    }
}

