/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.sockets.sslengine;

import com.subgraph.orchid.sockets.sslengine.SSLEngineManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class SSLEngineInputStream
extends InputStream {
    private final SSLEngineManager manager;
    private final ByteBuffer recvBuffer;
    private boolean isEOF;

    SSLEngineInputStream(SSLEngineManager manager) {
        this.manager = manager;
        this.recvBuffer = manager.getRecvBuffer();
    }

    @Override
    public int read() throws IOException {
        if (!this.fillRecvBufferIfEmpty()) {
            return -1;
        }
        int b = this.recvBuffer.get() & 0xFF;
        this.recvBuffer.compact();
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.fillRecvBufferIfEmpty()) {
            return -1;
        }
        int copyLen = Math.min(this.recvBuffer.remaining(), len);
        this.recvBuffer.get(b, off, copyLen);
        this.recvBuffer.compact();
        return copyLen;
    }

    @Override
    public void close() throws IOException {
        this.manager.close();
    }

    private boolean fillRecvBufferIfEmpty() throws IOException {
        if (this.isEOF) {
            return false;
        }
        if (this.recvBuffer.position() == 0 && this.manager.read() < 0) {
            this.isEOF = true;
            return false;
        }
        this.recvBuffer.flip();
        return this.recvBuffer.hasRemaining();
    }
}

