/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.socks;

import com.subgraph.orchid.CircuitManager;
import com.subgraph.orchid.OpenFailedException;
import com.subgraph.orchid.Stream;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.TorException;
import com.subgraph.orchid.socks.Socks4Request;
import com.subgraph.orchid.socks.Socks5Request;
import com.subgraph.orchid.socks.SocksRequest;
import com.subgraph.orchid.socks.SocksRequestException;
import com.subgraph.orchid.socks.SocksStreamConnection;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocksClientTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(SocksClientTask.class.getName());
    private final TorConfig config;
    private final Socket socket;
    private final CircuitManager circuitManager;

    SocksClientTask(TorConfig config, Socket socket, CircuitManager circuitManager) {
        this.config = config;
        this.socket = socket;
        this.circuitManager = circuitManager;
    }

    @Override
    public void run() {
        int version = this.readByte();
        this.dispatchRequest(version);
        this.closeSocket();
    }

    private int readByte() {
        try {
            return this.socket.getInputStream().read();
        }
        catch (IOException e) {
            logger.warning("IO error reading version byte: " + e.getMessage());
            return -1;
        }
    }

    private void dispatchRequest(int versionByte) {
        switch (versionByte) {
            case 71: 
            case 72: 
            case 80: {
                this.sendHttpPage();
                break;
            }
            case 4: {
                this.processRequest(new Socks4Request(this.config, this.socket));
                break;
            }
            case 5: {
                this.processRequest(new Socks5Request(this.config, this.socket));
                break;
            }
        }
    }

    private void processRequest(SocksRequest request) {
        try {
            request.readRequest();
            if (!request.isConnectRequest()) {
                logger.warning("Non connect command (" + request.getCommandCode() + ")");
                request.sendError(true);
                return;
            }
            try {
                Stream stream = this.openConnectStream(request);
                logger.fine("SOCKS CONNECT to " + request.getTarget() + " completed");
                request.sendSuccess();
                this.runOpenConnection(stream);
            }
            catch (InterruptedException e) {
                logger.info("SOCKS CONNECT to " + request.getTarget() + " was thread interrupted");
                Thread.currentThread().interrupt();
                request.sendError(false);
            }
            catch (TimeoutException e) {
                logger.info("SOCKS CONNECT to " + request.getTarget() + " timed out");
                request.sendError(false);
            }
            catch (OpenFailedException e) {
                logger.info("SOCKS CONNECT to " + request.getTarget() + " failed: " + e.getMessage());
                request.sendConnectionRefused();
            }
        }
        catch (SocksRequestException e) {
            logger.log(Level.WARNING, "Failure reading SOCKS request: " + e.getMessage());
            try {
                request.sendError(false);
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void runOpenConnection(Stream stream) {
        SocksStreamConnection.runConnection(this.socket, stream);
    }

    private Stream openConnectStream(SocksRequest request) throws InterruptedException, TimeoutException, OpenFailedException {
        if (request.hasHostname()) {
            logger.fine("SOCKS CONNECT request to " + request.getHostname() + ":" + request.getPort());
            return this.circuitManager.openExitStreamTo(request.getHostname(), request.getPort());
        }
        logger.fine("SOCKS CONNECT request to " + request.getAddress() + ":" + request.getPort());
        return this.circuitManager.openExitStreamTo(request.getAddress(), request.getPort());
    }

    private void sendHttpPage() {
        throw new TorException("Returning HTTP page not implemented");
    }

    private void closeSocket() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            logger.warning("Error closing SOCKS socket: " + e.getMessage());
        }
    }
}

