/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.socks;

import com.subgraph.orchid.CircuitManager;
import com.subgraph.orchid.SocksPortListener;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.TorException;
import com.subgraph.orchid.socks.SocksClientTask;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

public class SocksPortListenerImpl
implements SocksPortListener {
    private static final Logger logger = Logger.getLogger(SocksPortListenerImpl.class.getName());
    private final Set<Integer> listeningPorts = new HashSet<Integer>();
    private final Map<Integer, AcceptTask> acceptThreads = new HashMap<Integer, AcceptTask>();
    private final TorConfig config;
    private final CircuitManager circuitManager;
    private final ExecutorService executor;
    private boolean isStopped;

    public SocksPortListenerImpl(TorConfig config, CircuitManager circuitManager) {
        this.config = config;
        this.circuitManager = circuitManager;
        this.executor = Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListeningPort(int port) {
        if (port <= 0 || port > 65535) {
            throw new TorException("Illegal listening port: " + port);
        }
        Set<Integer> set = this.listeningPorts;
        synchronized (set) {
            if (this.isStopped) {
                throw new IllegalStateException("Cannot add listening port because Socks proxy has been stopped");
            }
            if (this.listeningPorts.contains(port)) {
                return;
            }
            this.listeningPorts.add(port);
            try {
                this.startListening(port);
                logger.fine("Listening for SOCKS connections on port " + port);
            }
            catch (IOException e) {
                this.listeningPorts.remove(port);
                throw new TorException("Failed to listen on port " + port + " : " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Set<Integer> set = this.listeningPorts;
        synchronized (set) {
            for (AcceptTask t : this.acceptThreads.values()) {
                t.stop();
            }
            this.executor.shutdownNow();
            this.isStopped = true;
        }
    }

    private void startListening(int port) throws IOException {
        AcceptTask task = new AcceptTask(port);
        this.acceptThreads.put(port, task);
        this.executor.execute(task);
    }

    private Runnable newClientSocket(Socket s) {
        return new SocksClientTask(this.config, s, this.circuitManager);
    }

    private class AcceptTask
    implements Runnable {
        private final ServerSocket socket;
        private final int port;
        private volatile boolean stopped;

        AcceptTask(int port) throws IOException {
            this.socket = new ServerSocket(port);
            this.port = port;
        }

        void stop() {
            this.stopped = true;
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.runAcceptLoop();
            }
            catch (IOException e) {
                if (!this.stopped) {
                    logger.warning("System error accepting SOCKS socket connections: " + e.getMessage());
                }
            }
            finally {
                Set set = SocksPortListenerImpl.this.listeningPorts;
                synchronized (set) {
                    SocksPortListenerImpl.this.listeningPorts.remove(this.port);
                    SocksPortListenerImpl.this.acceptThreads.remove(this.port);
                }
            }
        }

        private void runAcceptLoop() throws IOException {
            while (!Thread.interrupted() && !this.stopped) {
                Socket s = this.socket.accept();
                SocksPortListenerImpl.this.executor.execute(SocksPortListenerImpl.this.newClientSocket(s));
            }
        }
    }
}

