/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.regex;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.SequenceRecord;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataURI;
import org.datavec.api.records.reader.SequenceRecordReader;
import org.datavec.api.records.reader.impl.FileRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexSequenceRecordReader
extends FileRecordReader
implements SequenceRecordReader {
    public static final String SKIP_NUM_LINES = NAME_SPACE + ".skipnumlines";
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    public static final LineErrorHandling DEFAULT_ERROR_HANDLING = LineErrorHandling.FailOnInvalid;
    public static final Logger LOG = LoggerFactory.getLogger(RegexSequenceRecordReader.class);
    private String regex;
    private int skipNumLines;
    private Pattern pattern;
    private transient Charset charset;
    private LineErrorHandling errorHandling;

    public RegexSequenceRecordReader(String regex, int skipNumLines) {
        this(regex, skipNumLines, DEFAULT_CHARSET, DEFAULT_ERROR_HANDLING);
    }

    public RegexSequenceRecordReader(String regex, int skipNumLines, Charset encoding, LineErrorHandling errorHandling) {
        this.regex = regex;
        this.skipNumLines = skipNumLines;
        this.pattern = Pattern.compile(regex);
        this.charset = encoding;
        this.errorHandling = errorHandling;
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        super.initialize(conf, split);
        this.skipNumLines = conf.getInt(SKIP_NUM_LINES, this.skipNumLines);
    }

    @Override
    public List<List<Writable>> sequenceRecord() {
        return this.nextSequence().getSequenceRecord();
    }

    @Override
    public List<List<Writable>> sequenceRecord(URI uri, DataInputStream dataInputStream) throws IOException {
        String fileContents = IOUtils.toString((InputStream)new BufferedInputStream(dataInputStream), (String)this.charset.name());
        return this.loadSequence(fileContents, uri);
    }

    private List<List<Writable>> loadSequence(String fileContents, URI uri) {
        String[] lines = fileContents.split("(\r\n)|\n");
        int numLinesSkipped = 0;
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        int lineCount = 0;
        block5: for (String line : lines) {
            ArrayList<Text> timeStep;
            ++lineCount;
            if (numLinesSkipped < this.skipNumLines) {
                ++numLinesSkipped;
                continue;
            }
            Matcher m = this.pattern.matcher(line);
            if (m.matches()) {
                int count = m.groupCount();
                timeStep = new ArrayList<Text>(count);
                for (int i = 1; i <= count; ++i) {
                    timeStep.add(new Text(m.group(i)));
                }
            } else {
                switch (this.errorHandling) {
                    case FailOnInvalid: {
                        throw new IllegalStateException("Invalid line: line does not match regex (line #" + lineCount + ", uri=\"" + uri + "\"), \", regex=" + this.regex + "\"; line=\"" + line + "\"");
                    }
                    case SkipInvalid: {
                        continue block5;
                    }
                    case SkipInvalidWithWarning: {
                        String warnMsg = "Skipping invalid line: line does not match regex (line #" + lineCount + ", uri=\"" + uri + "\"), \"; line=\"" + line + "\"";
                        LOG.warn(warnMsg);
                        continue block5;
                    }
                    default: {
                        throw new RuntimeException("Unknown error handling mode: " + (Object)((Object)this.errorHandling));
                    }
                }
            }
            out.add(timeStep);
        }
        return out;
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public SequenceRecord nextSequence() {
        String fileContents;
        Preconditions.checkState((boolean)this.hasNext(), (String)"No next element available");
        URI next = (URI)this.locationsIterator.next();
        try (InputStream s = (InputStream)this.streamCreatorFn.apply((Object)next);){
            fileContents = IOUtils.toString((InputStream)s, (Charset)this.charset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List<List<Writable>> sequence = this.loadSequence(fileContents, next);
        return new org.datavec.api.records.impl.SequenceRecord(sequence, new RecordMetaDataURI(next, RegexSequenceRecordReader.class));
    }

    @Override
    public SequenceRecord loadSequenceFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.loadSequenceFromMetaData(Collections.singletonList(recordMetaData)).get(0);
    }

    @Override
    public List<SequenceRecord> loadSequenceFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        ArrayList<SequenceRecord> out = new ArrayList<SequenceRecord>();
        for (RecordMetaData meta : recordMetaDatas) {
            File next = new File(meta.getURI());
            URI uri = next.toURI();
            String fileContents = FileUtils.readFileToString((File)next, (String)this.charset.name());
            List<List<Writable>> sequence = this.loadSequence(fileContents, uri);
            out.add(new org.datavec.api.records.impl.SequenceRecord(sequence, meta));
        }
        return out;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        String s = ois.readUTF();
        this.charset = Charset.forName(s);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeUTF(this.charset.name());
    }

    public static enum LineErrorHandling {
        FailOnInvalid,
        SkipInvalid,
        SkipInvalidWithWarning;

    }
}

