/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.quality.columns;

import org.datavec.api.transform.quality.columns.ColumnQuality;

public class DoubleQuality
extends ColumnQuality {
    private final long countNonReal;
    private final long countNaN;
    private final long countInfinite;

    public DoubleQuality() {
        this(0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    public DoubleQuality(long countValid, long countInvalid, long countMissing, long countTotal, long countNonReal, long countNaN, long countInfinite) {
        super(countValid, countInvalid, countMissing, countTotal);
        this.countNonReal = countNonReal;
        this.countNaN = countNaN;
        this.countInfinite = countInfinite;
    }

    public DoubleQuality add(DoubleQuality other) {
        return new DoubleQuality(this.countValid + other.countValid, this.countInvalid + other.countInvalid, this.countMissing + other.countMissing, this.countTotal + other.countTotal, this.countNonReal + other.countNonReal, this.countNaN + other.countNaN, this.countInfinite + other.countInfinite);
    }

    @Override
    public String toString() {
        return "DoubleQuality(" + super.toString() + ", countNonReal=" + this.countNonReal + ", countNaN=" + this.countNaN + ", countInfinite=" + this.countInfinite + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleQuality)) {
            return false;
        }
        DoubleQuality other = (DoubleQuality)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCountNonReal() != other.getCountNonReal()) {
            return false;
        }
        if (this.getCountNaN() != other.getCountNaN()) {
            return false;
        }
        return this.getCountInfinite() == other.getCountInfinite();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DoubleQuality;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $countNonReal = this.getCountNonReal();
        result = result * 59 + (int)($countNonReal >>> 32 ^ $countNonReal);
        long $countNaN = this.getCountNaN();
        result = result * 59 + (int)($countNaN >>> 32 ^ $countNaN);
        long $countInfinite = this.getCountInfinite();
        result = result * 59 + (int)($countInfinite >>> 32 ^ $countInfinite);
        return result;
    }

    public long getCountNonReal() {
        return this.countNonReal;
    }

    public long getCountNaN() {
        return this.countNaN;
    }

    public long getCountInfinite() {
        return this.countInfinite;
    }
}

