/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.parse;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseTransform;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class ParseDoubleTransform
extends BaseTransform {
    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public Schema transform(Schema inputSchema) {
        Schema.Builder newSchema = new Schema.Builder();
        for (int i = 0; i < inputSchema.numColumns(); ++i) {
            if (inputSchema.getType(i) == ColumnType.String) {
                newSchema.addColumnDouble(inputSchema.getMetaData(i).getName());
                continue;
            }
            newSchema.addColumn(inputSchema.getMetaData(i));
        }
        return newSchema.build();
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        ArrayList<Writable> transform = new ArrayList<Writable>();
        for (Writable w : writables) {
            if (w instanceof Text) {
                transform.add(new DoubleWritable(w.toDouble()));
                continue;
            }
            transform.add(w);
        }
        return transform;
    }

    @Override
    public Object map(Object input) {
        return Double.parseDouble(input.toString());
    }

    @Override
    public Object mapSequence(Object sequence) {
        List list = (List)sequence;
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object o : list) {
            ret.add(this.map(o));
        }
        return ret;
    }

    @Override
    public String outputColumnName() {
        return this.getInputSchema().getColumnNames().get(0);
    }

    @Override
    public String[] outputColumnNames() {
        return this.inputSchema.getColumnNames().toArray(new String[this.inputSchema.numColumns()]);
    }

    @Override
    public String[] columnNames() {
        return this.inputSchema.getColumnNames().toArray(new String[this.inputSchema.numColumns()]);
    }

    @Override
    public String columnName() {
        return this.outputColumnName();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParseDoubleTransform)) {
            return false;
        }
        ParseDoubleTransform other = (ParseDoubleTransform)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ParseDoubleTransform;
    }

    @Override
    public int hashCode() {
        int result = 1;
        return result;
    }
}

