/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.codec.reader;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.SequenceRecord;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataURI;
import org.datavec.api.records.reader.SequenceRecordReader;
import org.datavec.api.records.reader.impl.FileRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.Writable;
import org.datavec.codec.reader.CodecRecordReader;

public abstract class BaseCodecRecordReader
extends FileRecordReader
implements SequenceRecordReader {
    protected int startFrame = 0;
    protected int numFrames = -1;
    protected int totalFrames = -1;
    protected double framesPerSecond = -1.0;
    protected double videoLength = -1.0;
    protected int rows = 28;
    protected int cols = 28;
    protected boolean ravel = false;
    public static final String NAME_SPACE = "org.datavec.codec.reader";
    public static final String ROWS = "org.datavec.codec.reader.rows";
    public static final String COLUMNS = "org.datavec.codec.reader.columns";
    public static final String START_FRAME = "org.datavec.codec.reader.startframe";
    public static final String TOTAL_FRAMES = "org.datavec.codec.reader.frames";
    public static final String TIME_SLICE = "org.datavec.codec.reader.time";
    public static final String RAVEL = "org.datavec.codec.reader.ravel";
    public static final String VIDEO_DURATION = "org.datavec.codec.reader.duration";

    public List<List<Writable>> sequenceRecord() {
        if (this.iter == null || !this.iter.hasNext()) {
            this.advanceToNextLocation();
        }
        File next = (File)this.iter.next();
        try {
            return this.loadData(next, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<List<Writable>> sequenceRecord(URI uri, DataInputStream dataInputStream) throws IOException {
        return this.loadData(null, dataInputStream);
    }

    protected abstract List<List<Writable>> loadData(File var1, InputStream var2) throws IOException;

    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.setConf(conf);
        this.initialize(split);
    }

    public List<Writable> next() {
        throw new UnsupportedOperationException("next() not supported for CodecRecordReader (use: sequenceRecord)");
    }

    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("record(URI,DataInputStream) not supported for CodecRecordReader");
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.startFrame = conf.getInt(START_FRAME, 0);
        this.numFrames = conf.getInt(TOTAL_FRAMES, -1);
        this.rows = conf.getInt(ROWS, 28);
        this.cols = conf.getInt(COLUMNS, 28);
        this.framesPerSecond = conf.getFloat(TIME_SLICE, -1.0f);
        this.videoLength = conf.getFloat(VIDEO_DURATION, -1.0f);
        this.ravel = conf.getBoolean(RAVEL, false);
        this.totalFrames = conf.getInt(TOTAL_FRAMES, -1);
    }

    public Configuration getConf() {
        return super.getConf();
    }

    public SequenceRecord nextSequence() {
        List<List<Writable>> list;
        File next = this.nextFile();
        try {
            list = this.loadData(next, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new org.datavec.api.records.impl.SequenceRecord(list, (RecordMetaData)new RecordMetaDataURI(next.toURI(), CodecRecordReader.class));
    }

    public SequenceRecord loadSequenceFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.loadSequenceFromMetaData(Collections.singletonList(recordMetaData)).get(0);
    }

    public List<SequenceRecord> loadSequenceFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        ArrayList<SequenceRecord> out = new ArrayList<SequenceRecord>();
        for (RecordMetaData meta : recordMetaDatas) {
            File f = new File(meta.getURI());
            List<List<Writable>> list = this.loadData(f, null);
            out.add((SequenceRecord)new org.datavec.api.records.impl.SequenceRecord(list, meta));
        }
        return out;
    }
}

